/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.tool;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.ToolExecutor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LC4jToolMapBuilder<T extends LC4jToolMapBuilder<T>> {
    private final Map<ToolSpecification, ToolExecutor> toolMap = new HashMap<ToolSpecification, ToolExecutor>();

    public Map<ToolSpecification, ToolExecutor> toolMap() {
        return Map.copyOf(this.toolMap);
    }

    protected T result() {
        return (T)this;
    }

    public final T toolsFromObject(Object objectWithTools) {
        for (Method method : objectWithTools.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Tool.class)) continue;
            DefaultToolExecutor toolExecutor = new DefaultToolExecutor(objectWithTools, method);
            this.toolMap.put(ToolSpecifications.toolSpecificationFrom((Method)method), (ToolExecutor)toolExecutor);
        }
        return this.result();
    }

    public final T tool(ToolSpecification spec, ToolExecutor executor) {
        this.toolMap.put(spec, executor);
        return this.result();
    }

    public final T tool(Map.Entry<ToolSpecification, ToolExecutor> entry) {
        this.toolMap.put(entry.getKey(), entry.getValue());
        return this.result();
    }

    public final T tool(McpClient mcpClient) {
        Objects.requireNonNull(mcpClient, "mcpClient cannot be null");
        for (ToolSpecification toolSpecification : mcpClient.listTools()) {
            this.tool(toolSpecification, (request, memoryId) -> mcpClient.executeTool(request));
        }
        return this.result();
    }
}

