/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bsc.langgraph4j.langchain4j.tool.LC4jToolMapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LC4jToolService {
    private static final Logger log = LoggerFactory.getLogger(LC4jToolService.class);
    private final Map<ToolSpecification, ToolExecutor> toolMap;

    public static Builder builder() {
        return new Builder();
    }

    public LC4jToolService(Map<ToolSpecification, ToolExecutor> toolMap) {
        this.toolMap = Objects.requireNonNull(toolMap, "toolMap cannot be null");
        if (toolMap.isEmpty()) {
            log.warn("tool chain is empty!");
        }
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolMap.keySet().stream().toList();
    }

    public Optional<ToolExecutionResultMessage> execute(ToolExecutionRequest request, Object memoryId) {
        Objects.requireNonNull(request, "request cannot be null");
        log.trace("execute: {}", (Object)request.name());
        return this.toolMap.entrySet().stream().filter(e -> Objects.equals(((ToolSpecification)e.getKey()).name(), request.name())).map(Map.Entry::getValue).findFirst().map(e -> {
            String value = e.execute(request, memoryId);
            return new ToolExecutionResultMessage(request.id(), request.name(), value);
        });
    }

    public Optional<ToolExecutionResultMessage> execute(Collection<ToolExecutionRequest> requests, Object memoryId) {
        Objects.requireNonNull(requests, "requests cannot be null");
        for (ToolExecutionRequest request : requests) {
            Optional<ToolExecutionResultMessage> result = this.execute(request, memoryId);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<ToolExecutionResultMessage> execute(ToolExecutionRequest request) {
        return this.execute(request, null);
    }

    public Optional<ToolExecutionResultMessage> execute(Collection<ToolExecutionRequest> requests) {
        return this.execute(requests, null);
    }

    public static class Builder
    extends LC4jToolMapBuilder<Builder> {
        @Deprecated
        public Builder specification(ToolSpecification spec, ToolExecutor executor) {
            return (Builder)super.tool(spec, executor);
        }

        @Deprecated
        public Builder specification(Specification toolSpecification) {
            return (Builder)super.tool(toolSpecification.value(), toolSpecification.executor());
        }

        @Deprecated
        public Builder specification(Object objectWithTools) {
            return (Builder)super.toolsFromObject(objectWithTools);
        }

        public LC4jToolService build() {
            return new LC4jToolService(this.toolMap());
        }
    }

    @Deprecated
    public record Specification(ToolSpecification value, ToolExecutor executor) {
        public static Specification of(ToolSpecification value, ToolExecutor executor) {
            return new Specification(Objects.requireNonNull(value, "value cannot be null"), Objects.requireNonNull(executor, "executor cannot be null"));
        }
    }
}

