/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.serializer.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.langchain4j.data.message.ChatMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class GenericMapDeserializer
extends StdDeserializer<Map<String, Object>> {
    public GenericMapDeserializer() {
        super(Map.class);
    }

    public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ObjectNode node = (ObjectNode)mapper.readTree(p);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry property : node.properties()) {
            String key = (String)property.getKey();
            JsonNode valueNode = (JsonNode)property.getValue();
            Object value = valueNode.isObject() && valueNode.has("@type") ? mapper.treeToValue((TreeNode)valueNode, ChatMessage.class) : (valueNode.isInt() ? Integer.valueOf(valueNode.intValue()) : (valueNode.isTextual() ? valueNode.textValue() : mapper.treeToValue((TreeNode)valueNode, Object.class)));
            result.put(key, value);
        }
        return result;
    }
}

