/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.tool;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.ToolExecutor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class LC4jToolMapBuilder<T extends LC4jToolMapBuilder<T>> {
    private final Map<ToolSpecification, ToolExecutor> toolMap = new HashMap<ToolSpecification, ToolExecutor>();

    public Map<ToolSpecification, ToolExecutor> toolMap() {
        return Map.copyOf(this.toolMap);
    }

    protected T result() {
        return (T)this;
    }

    public final T toolsFromObject(Object objectWithTools) {
        Class<?> clazz = Objects.requireNonNull(objectWithTools, "class cannot be null").getClass();
        List<Object> toolMethods = List.of();
        while (clazz != null && clazz != Object.class && (toolMethods = Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).toList()).isEmpty()) {
            if (!clazz.isSynthetic()) continue;
            clazz = clazz.getSuperclass();
        }
        toolMethods.forEach(method -> {
            DefaultToolExecutor toolExecutor = new DefaultToolExecutor(objectWithTools, method);
            this.toolMap.put(ToolSpecifications.toolSpecificationFrom((Method)method), (ToolExecutor)toolExecutor);
        });
        return this.result();
    }

    public final T toolsFromObject(Object ... objectWithTools) {
        Stream.of(objectWithTools).forEach(this::toolsFromObject);
        return this.result();
    }

    public final T tool(ToolSpecification spec, ToolExecutor executor) {
        this.toolMap.put(spec, executor);
        return this.result();
    }

    public final T tool(Map.Entry<ToolSpecification, ToolExecutor> entry) {
        this.toolMap.put(entry.getKey(), entry.getValue());
        return this.result();
    }

    public final T tool(McpClient mcpClient) {
        Objects.requireNonNull(mcpClient, "mcpClient cannot be null");
        for (ToolSpecification toolSpecification : mcpClient.listTools()) {
            this.tool(toolSpecification, (request, o) -> mcpClient.executeTool(request).resultText());
        }
        return this.result();
    }
}

