/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.bsc.langgraph4j.action.Command;
import org.bsc.langgraph4j.langchain4j.tool.LC4jToolMapBuilder;
import org.bsc.langgraph4j.utils.CollectionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LC4jToolService {
    private static final Logger log = LoggerFactory.getLogger(LC4jToolService.class);
    private final Map<ToolSpecification, ToolExecutor> toolMap;

    public static Builder builder() {
        return new Builder();
    }

    public LC4jToolService(Map<ToolSpecification, ToolExecutor> toolMap) {
        this.toolMap = Objects.requireNonNull(toolMap, "toolMap cannot be null");
        if (toolMap.isEmpty()) {
            log.warn("tool chain is empty!");
        }
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolMap.keySet().stream().toList();
    }

    public CompletableFuture<Command> execute(List<ToolExecutionRequest> requests, InvocationContext context, String propertyNameToUpdate) {
        Objects.requireNonNull(requests, "requests cannot be null");
        Objects.requireNonNull(propertyNameToUpdate, "propertyNameToUpdate cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        log.trace("execute: {}", requests.stream().map(ToolExecutionRequest::name).toList());
        ArrayList<ToolExecutionResultMessage> toolResponses = new ArrayList<ToolExecutionResultMessage>(requests.size());
        Map update = Map.of();
        String gotoNode = null;
        for (ToolExecutionRequest request : requests) {
            Optional<ScopedToolCallResult> optionalResult = this.scopedToolCall(request, context);
            if (optionalResult.isEmpty()) {
                log.warn("tool '{}' not found!", (Object)request.name());
                continue;
            }
            Command command = optionalResult.get().command();
            if (command.gotoNodeSafe().isPresent()) {
                if (gotoNode != null) {
                    return CompletableFuture.failedFuture(new IllegalStateException(String.format("Multiple nodes target provided! tried to set %s when %s was already present : ", command.gotoNode(), gotoNode)));
                }
                gotoNode = command.gotoNode();
            }
            update = CollectionsUtils.mergeMap((Map)update, (Map)command.update(), (v1, v2) -> v2);
            toolResponses.add(optionalResult.get().toolResultMessage());
        }
        update = CollectionsUtils.mergeMap(update, Map.of(propertyNameToUpdate, toolResponses));
        return CompletableFuture.completedFuture(new Command(gotoNode, update));
    }

    private Optional<ScopedToolCallResult> scopedToolCall(ToolExecutionRequest request, InvocationContext toolContext) {
        AtomicReference scopedCommandResult = new AtomicReference();
        return this.toolMap.entrySet().stream().filter(e -> Objects.equals(((ToolSpecification)e.getKey()).name(), request.name())).map(Map.Entry::getValue).findFirst().map(e -> {
            Map contextMapData = CollectionsUtils.mergeMap((Map)Optional.ofNullable(toolContext.invocationParameters()).map(InvocationParameters::asMap).orElseGet(Map::of), Map.of("AtomicReference<Command>", scopedCommandResult), (v1, v2) -> v2);
            InvocationContext newToolContext = InvocationContext.builder().chatMemoryId(toolContext.chatMemoryId()).invocationParameters(InvocationParameters.from((Map)contextMapData)).build();
            return e.executeWithContext(request, newToolContext);
        }).map(result -> new ToolExecutionResultMessage(request.id(), request.name(), result.resultText())).map(toolResultMessage -> new ScopedToolCallResult((ToolExecutionResultMessage)toolResultMessage, (Command)scopedCommandResult.get()));
    }

    public static class Builder
    extends LC4jToolMapBuilder<Builder> {
        @Deprecated
        public Builder specification(ToolSpecification spec, ToolExecutor executor) {
            return (Builder)super.tool(spec, executor);
        }

        @Deprecated
        public Builder specification(Specification toolSpecification) {
            return (Builder)super.tool(toolSpecification.value(), toolSpecification.executor());
        }

        @Deprecated
        public Builder specification(Object objectWithTools) {
            return (Builder)super.toolsFromObject(objectWithTools);
        }

        public LC4jToolService build() {
            return new LC4jToolService(this.toolMap());
        }
    }

    private record ScopedToolCallResult(ToolExecutionResultMessage toolResultMessage, Command command) {
        private final Command command;

        ScopedToolCallResult {
            Objects.requireNonNull(toolResultMessage, "response cannot be null");
        }

        public Command command() {
            return Optional.ofNullable(this.command).orElseGet(Command::emptyCommand);
        }
    }

    @Deprecated
    public record Specification(ToolSpecification value, ToolExecutor executor) {
        public static Specification of(ToolSpecification value, ToolExecutor executor) {
            return new Specification(Objects.requireNonNull(value, "value cannot be null"), Objects.requireNonNull(executor, "executor cannot be null"));
        }
    }
}

