/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.util;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import java.util.Optional;

public class ChatMessageUtil {
    public static boolean isToolExecutionResultMessage(ChatMessage message) {
        return Optional.ofNullable(message).map(m -> m.type().equals((Object)ChatMessageType.TOOL_EXECUTION_RESULT)).orElse(false);
    }

    public static Optional<ToolExecutionResultMessage> asToolExecutionResultMessage(ChatMessage message) {
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage result = (ToolExecutionResultMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static boolean isAiMessage(ChatMessage message) {
        return Optional.ofNullable(message).map(m -> m.type().equals((Object)ChatMessageType.AI)).orElse(false);
    }

    public static Optional<AiMessage> asAiMessage(ChatMessage message) {
        if (message instanceof AiMessage) {
            AiMessage result = (AiMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static boolean isSystemMessage(ChatMessage message) {
        return Optional.ofNullable(message).map(m -> m.type().equals((Object)ChatMessageType.SYSTEM)).orElse(false);
    }

    public static Optional<SystemMessage> asSystemMessage(ChatMessage message) {
        if (message instanceof SystemMessage) {
            SystemMessage result = (SystemMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static boolean isUserMessage(ChatMessage message) {
        return Optional.ofNullable(message).map(m -> m.type().equals((Object)ChatMessageType.USER)).orElse(false);
    }

    public static Optional<UserMessage> asUserMessage(ChatMessage message) {
        if (message instanceof UserMessage) {
            UserMessage result = (UserMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

