/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.reporting.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.bsc.reporting.renderer.ReportingResolutionListener;
import org.codehaus.plexus.i18n.I18N;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DependenciesRenderer
extends AbstractMavenReportRenderer {
    private final Locale locale;
    private final ReportingResolutionListener listener;
    private final MavenProject project;
    private final MavenProjectBuilder mavenProjectBuilder;
    private final ArtifactRepository localRepository;
    private final ArtifactFactory factory;
    private final I18N i18n;
    private final Log log;

    public DependenciesRenderer(Sink sink, MavenProject project, MavenProjectBuilder mavenProjectBuilder, ArtifactRepository localRepository, ArtifactFactory factory, I18N i18n, Locale locale, ReportingResolutionListener listener, Log log) {
        super(sink);
        this.project = project;
        this.locale = locale;
        this.listener = listener;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.localRepository = localRepository;
        this.i18n = i18n;
        this.factory = factory;
        this.log = log;
    }

    public String getTitle() {
        return this.getReportString("report.dependencies.title");
    }

    public void renderBody() {
        List<ReportingResolutionListener.Node> dependencies = this.listener.getRootNode().getChildren();
        if (dependencies.isEmpty()) {
            this.startSection(this.getTitle());
            this.paragraph(this.getReportString("report.dependencies.nolist"));
            this.endSection();
            return;
        }
        this.startSection(this.getTitle());
        String groupId = this.getReportString("report.dependencies.column.groupId");
        String artifactId = this.getReportString("report.dependencies.column.artifactId");
        String version = this.getReportString("report.dependencies.column.version");
        String classifier = this.getReportString("report.dependencies.column.classifier");
        String type = this.getReportString("report.dependencies.column.type");
        String optional = this.getReportString("report.dependencies.column.optional");
        String[] tableHeader = new String[]{groupId, artifactId, version, classifier, type, optional};
        Map<String, List<Artifact>> dependenciesByScope = this.getDependenciesByScope(dependencies);
        this.renderDependenciesForScope("compile", dependenciesByScope.get("compile"), tableHeader);
        this.renderDependenciesForScope("runtime", dependenciesByScope.get("runtime"), tableHeader);
        this.renderDependenciesForScope("test", dependenciesByScope.get("test"), tableHeader);
        this.renderDependenciesForScope("provided", dependenciesByScope.get("provided"), tableHeader);
        this.renderDependenciesForScope("system", dependenciesByScope.get("system"), tableHeader);
        this.endSection();
        ArrayList<ReportingResolutionListener.Node> artifacts = new ArrayList<ReportingResolutionListener.Node>(this.listener.getArtifacts());
        artifacts.removeAll(dependencies);
        this.startSection(this.getReportString("report.dependencies.transitive.title"));
        if (artifacts.isEmpty()) {
            this.paragraph(this.getReportString("report.dependencies.transitive.nolist"));
        } else {
            this.paragraph(this.getReportString("report.dependencies.transitive.intro"));
            dependenciesByScope = this.getDependenciesByScope(artifacts);
            this.renderDependenciesForScope("compile", dependenciesByScope.get("compile"), tableHeader);
            this.renderDependenciesForScope("runtime", dependenciesByScope.get("runtime"), tableHeader);
            this.renderDependenciesForScope("test", dependenciesByScope.get("test"), tableHeader);
            this.renderDependenciesForScope("provided", dependenciesByScope.get("provided"), tableHeader);
            this.renderDependenciesForScope("system", dependenciesByScope.get("system"), tableHeader);
        }
        this.endSection();
        this.startSection(this.getReportString("report.dependencies.graph.title"));
        this.startSection(this.getReportString("report.dependencies.graph.tree.title"));
        this.sink.lineBreak();
        this.sink.paragraph();
        this.printDependencyListing(this.listener.getRootNode(), false);
        this.sink.paragraph_();
        this.endSection();
        this.startSection(this.getReportString("report.dependencies.file.details.title"));
        this.printDescriptionsAndURLs(this.listener.getRootNode());
        this.endSection();
        this.endSection();
    }

    private Map<String, List<Artifact>> getDependenciesByScope(List<ReportingResolutionListener.Node> dependencies) {
        HashMap<String, List<Artifact>> dependenciesByScope = new HashMap<String, List<Artifact>>();
        dependencies.forEach(node -> {
            Artifact artifact = node.getArtifact();
            ArrayList<Artifact> multiValue = (ArrayList<Artifact>)dependenciesByScope.get(artifact.getScope());
            if (multiValue == null) {
                multiValue = new ArrayList<Artifact>();
            }
            multiValue.add(artifact);
            dependenciesByScope.put(artifact.getScope(), multiValue);
        });
        return dependenciesByScope;
    }

    private void renderDependenciesForScope(String scope, List<Artifact> artifacts, String[] tableHeader) {
        if (artifacts != null) {
            Collections.sort(artifacts, this.getArtifactComparator());
            this.startSection(scope);
            this.paragraph(this.getReportString("report.dependencies.intro." + scope));
            this.startTable();
            this.tableHeader(tableHeader);
            artifacts.forEach(artifact -> this.tableRow(this.getArtifactRow((Artifact)artifact)));
            this.endTable();
            this.endSection();
        }
    }

    private Comparator<Artifact> getArtifactComparator() {
        return (a1, a2) -> {
            if (a1.isOptional() && !a2.isOptional()) {
                return 1;
            }
            if (!a1.isOptional() && a2.isOptional()) {
                return -1;
            }
            return a1.compareTo(a2);
        };
    }

    private String[] getArtifactRow(Artifact artifact) {
        return new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getType(), artifact.isOptional() ? "(optional)" : " "};
    }

    private void printDependencyListing(ReportingResolutionListener.Node node, boolean printRoot) {
        Artifact artifact = node.getArtifact();
        String id = artifact.getDependencyConflictId();
        this.sink.listItem();
        this.sink.paragraph();
        if (printRoot) {
            this.sink.link("#" + id);
            this.sink.text(id);
            this.sink.link_();
        }
        if (!node.getChildren().isEmpty()) {
            this.sink.list();
            node.getChildren().forEach(dep -> this.printDependencyListing((ReportingResolutionListener.Node)dep, true));
            this.sink.list_();
        }
        this.sink.paragraph_();
        this.sink.listItem_();
    }

    private void printDescriptionsAndURLs(ReportingResolutionListener.Node node) {
        Artifact artifact = node.getArtifact();
        String id = artifact.getDependencyConflictId();
        if (!"system".equals(artifact.getScope())) {
            try {
                MavenProject artifactProject = this.getMavenProjectFromRepository(artifact, this.localRepository);
                String artifactDescription = artifactProject.getDescription();
                String artifactUrl = artifactProject.getUrl();
                String artifactName = artifactProject.getName();
                this.sink.paragraph();
                this.sink.anchor(id);
                this.sink.bold();
                this.sink.text(artifactName);
                this.sink.bold_();
                this.sink.anchor_();
                this.sink.paragraph_();
                if (artifactDescription != null) {
                    this.sink.paragraph();
                    this.sink.text(artifactDescription);
                    this.sink.paragraph_();
                }
                if (artifactUrl != null) {
                    this.sink.paragraph();
                    this.sink.link(artifactUrl);
                    this.sink.text(artifactUrl);
                    this.sink.link_();
                    this.sink.paragraph_();
                }
            }
            catch (ProjectBuildingException e) {
                this.log.debug((Throwable)e);
            }
            node.getChildren().forEach(dep -> this.printDescriptionsAndURLs((ReportingResolutionListener.Node)dep));
        } else {
            this.sink.paragraph();
            this.sink.anchor(id);
            this.sink.bold();
            this.sink.text(id);
            this.sink.bold_();
            this.sink.anchor_();
            this.sink.paragraph_();
            this.sink.paragraph();
            this.sink.text(artifact.getFile().toString());
            this.sink.paragraph_();
        }
    }

    private MavenProject getMavenProjectFromRepository(Artifact artifact, ArtifactRepository localRepository) throws ProjectBuildingException {
        Artifact projectArtifact = artifact;
        boolean allowStubModel = false;
        if (!"pom".equals(artifact.getType())) {
            projectArtifact = this.factory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            allowStubModel = true;
        }
        return this.mavenProjectBuilder.buildFromRepository(projectArtifact, this.project.getRemoteArtifactRepositories(), localRepository, allowStubModel);
    }

    private String getReportString(String key) {
        return this.i18n.getString("project-info-report", this.locale, key);
    }
}

