/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.xmlrpc.ConfluenceExportDecorator;
import org.bsc.mojo.AbstractBaseConfluenceMojo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Mojo(name="export", threadSafe=true, requiresProject=false)
public class ConfluenceExportMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(alias="title", property="confluence.page", defaultValue="${project.build.finalName}")
    private String pageTitle;
    @Parameter(alias="outputType", property="outputType", defaultValue="pdf")
    private String outputType;
    @Parameter(alias="outputFile")
    private File outputFile;
    @Parameter(property="project.build.directory", readonly=true)
    private File outputDirectory;

    private CompletableFuture<Void> exportPage(ConfluenceService confluence, ConfluenceService.Model.Page parentPage) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ExportFormat exfmt = ExportFormat.valueOf((String)this.outputType.toUpperCase());
        this.outputFile = Optional.ofNullable(this.outputFile).orElseGet(() -> {
            String fileName = String.format("%s.%s", this.pageTitle, exfmt.name().toLowerCase());
            File file = Optional.ofNullable(this.outputDirectory).map(dir -> new File((File)dir, fileName)).orElseGet(() -> new File(fileName));
            return file;
        });
        try {
            FileUtils.forceMkdir((File)new File(this.outputFile.getParent()));
            String url = ConfluenceService.Protocol.XMLRPC.removeFrom(ConfluenceExportMojo.super.getEndPoint());
            ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(confluence, url);
            exporter.exportPage(parentPage.getSpace(), this.pageTitle, exfmt, this.outputFile);
            result.complete(null);
        }
        catch (IOException e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public void execute(ConfluenceService confluence) throws Exception {
        ((CompletableFuture)this.loadParentPage(confluence, Optional.empty()).thenCompose(parentPage -> this.exportPage(confluence, (ConfluenceService.Model.Page)parentPage))).join();
    }
}

