/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

class PlexusJavaCompilerWithOutput {
    static final PlexusJavaCompilerWithOutput INSTANCE = new PlexusJavaCompilerWithOutput();

    private PlexusJavaCompilerWithOutput() {
    }

    private String getJavacExecutable(CompilerConfiguration config) throws IOException {
        if (!StringUtils.isEmpty((String)config.getExecutable())) {
            return config.getExecutable();
        }
        String javacCommand = "javac" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        PrintWriter writer = null;
        try {
            File tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
            tempFile.deleteOnExit();
            writer = new PrintWriter(new FileWriter(tempFile));
            for (String arg : args) {
                String argValue = arg.replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        int returnCode;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
        cli.setExecutable(executable);
        try {
            File argumentsFile = this.createFileWithArguments(args, config.getOutputLocation());
            cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
            if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
            }
            if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
            }
            for (String key : config.getCustomCompilerArgumentsAsMap().keySet()) {
                if (!StringUtils.isNotEmpty((String)key) || !key.startsWith("-J")) continue;
                cli.addArguments(new String[]{key});
            }
        }
        catch (IOException e) {
            throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
        }
        final CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        List messages = Collections.emptyList();
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (Exception e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        boolean success = returnCode == 0;
        return new CompilerResult(success, messages){

            public String toString() {
                return out.getOutput();
            }
        };
    }

    private String[] getSourceFiles(CompilerConfiguration config) throws IOException {
        HashSet<String> sourceFiles = new HashSet<String>();
        for (File src : config.getSourceFiles()) {
            sourceFiles.add(src.getCanonicalPath());
        }
        return sourceFiles.toArray(new String[sourceFiles.size()]);
    }

    protected CompilerResult performCompile(CompilerConfiguration config) throws CompilerException, IOException {
        HashSet<String> sourceFiles = new HashSet<String>();
        for (File src : config.getSourceFiles()) {
            sourceFiles.add(src.getCanonicalPath());
        }
        String[] compilerArguments = JavacCompiler.buildCompilerArguments((CompilerConfiguration)config, (String[])this.getSourceFiles(config));
        return this.compileOutOfProcess(config, this.getJavacExecutable(config), compilerArguments);
    }
}

