/*
 * Decompiled with CFR 0.152.
 */
package org.buildobjects.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.buildobjects.process.EventSink;
import org.buildobjects.process.ExecutionEvent;
import org.buildobjects.process.OutputConsumptionThread;

class ByteArrayConsumptionThread
implements OutputConsumptionThread {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private Thread thread;
    private Throwable throwable;
    private byte[] bytes;
    private final EventSink eventSink;

    ByteArrayConsumptionThread(EventSink eventSink) {
        this.eventSink = eventSink;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void startConsumption(final InputStream inputStream) {
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    ByteArrayConsumptionThread.access$002(ByteArrayConsumptionThread.this, ByteArrayConsumptionThread.toByteArray(inputStream));
                }
                catch (Throwable t) {
                    ByteArrayConsumptionThread.this.throwable = t;
                    ByteArrayConsumptionThread.this.eventSink.dispatch(ExecutionEvent.EXCEPTION_IN_STREAM_HANDLING);
                }
            }
        });
        this.thread.start();
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = inputStream.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public void join() throws InterruptedException {
        this.thread.join();
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    static /* synthetic */ byte[] access$002(ByteArrayConsumptionThread x0, byte[] x1) {
        x0.bytes = x1;
        return x1;
    }
}

