/*
 * Decompiled with CFR 0.152.
 */
package org.buildobjects.process;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public class ExternalProcessFailureException
extends RuntimeException {
    private final String command;
    private final String commandLine;
    private final int exitValue;
    private final String stderr;
    private final ByteArrayOutputStream stdout;
    private final long time;

    ExternalProcessFailureException(String command, String commandLine, int exitValue, String stderr, ByteArrayOutputStream stdOut, long time) {
        this.command = command;
        this.commandLine = commandLine;
        this.exitValue = exitValue;
        this.stderr = stderr;
        this.stdout = stdOut;
        this.time = time;
    }

    private String formatOutput(String string, String prefix) {
        if (string == null) {
            return prefix + "<Has already been consumed.>\n";
        }
        if (string.isEmpty()) {
            return "";
        }
        return this.prefixLines(string, prefix);
    }

    private String prefixLines(String string, String prefix) {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        for (String line : lines = string.split("\n")) {
            builder.append(prefix + line + "\n");
        }
        return builder.toString();
    }

    @Override
    public String getMessage() {
        String formattedStdErr = this.formatOutput(this.stderr, "  STDERR: ");
        String outString = this.stdout != null ? new String(this.stdout.toByteArray(), StandardCharsets.UTF_8) : null;
        String formattedStdOut = this.formatOutput(outString, "  STDOUT: ");
        return "External process `" + this.command + "` terminated with unexpected exit status " + this.exitValue + " after " + this.time + "ms:\n  $ " + this.commandLine + "\n" + formattedStdErr + formattedStdOut;
    }

    @Deprecated
    public String getCommand() {
        return this.commandLine;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getStderr() {
        return this.stderr;
    }

    public long getTime() {
        return this.time;
    }
}

