/*
 * Decompiled with CFR 0.152.
 */
package org.buildobjects.process;

import java.io.InputStream;
import java.io.OutputStream;
import org.buildobjects.process.EventSink;
import org.buildobjects.process.ExecutionEvent;
import org.buildobjects.process.OutputConsumptionThread;
import org.buildobjects.process.StreamCopyRunner;

class StreamCopyConsumptionThread
implements OutputConsumptionThread {
    private final OutputStream stdout;
    private Thread thread;
    private Throwable throwable;
    private final EventSink eventSink;

    public StreamCopyConsumptionThread(OutputStream stdout, EventSink eventSink) {
        this.stdout = stdout;
        this.eventSink = eventSink;
    }

    @Override
    public void startConsumption(final InputStream inputStream) {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new StreamCopyRunner(inputStream, StreamCopyConsumptionThread.this.stdout, false).run();
                }
                catch (Throwable t) {
                    StreamCopyConsumptionThread.this.throwable = t;
                    StreamCopyConsumptionThread.this.eventSink.dispatch(ExecutionEvent.EXCEPTION_IN_STREAM_HANDLING);
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void join() throws InterruptedException {
        this.thread.join();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

