/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashingOutputStream
extends OutputStream {
    private MessageDigest md;
    OutputStream out;

    public HashingOutputStream(String algorithm, OutputStream out) throws NoSuchAlgorithmException {
        this.out = out;
        this.md = MessageDigest.getInstance(algorithm);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.md.update((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.md.update(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.md.update(b, off, len);
    }

    public byte[] getHash() {
        return this.md.digest();
    }
}

