/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.ServerThreadPool;

public class ServerThread {
    Logger logger = Logger.getLogger(ServerThread.class);
    public static final String STATE_CLIENT_ADDRESS = "client address";
    public static final String STATE_LOCAL_ADDRESS = "local address";
    public static final String STATE_LIFE = "life";
    private static Long instances = new Long(0L);
    private long id;
    private long clientsHandled;
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private Protocol protocol;
    private String protocolName;
    private long timeout;
    private long life;
    private Thread myThread;
    private ServerThreadPool pool;

    public long getId() {
        return this.id;
    }

    public long getClientsHandled() {
        return this.clientsHandled;
    }

    public ServerThreadPool getPool() {
        return this.pool;
    }

    protected void setPool(ServerThreadPool pool) {
        this.pool = pool;
    }

    protected Thread getMyThread() {
        return this.myThread;
    }

    protected void setMyThread(Thread myThread) {
        this.myThread = myThread;
    }

    protected InputStream getInput() {
        return this.input;
    }

    protected void setInput(InputStream input) {
        this.input = input;
    }

    protected long getLife() {
        return this.life;
    }

    protected void setLife(long life) {
        this.life = life;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected void setOutput(OutputStream output) {
        this.output = output;
    }

    protected Protocol getProtocol() {
        return this.protocol;
    }

    protected void setProtocol(String protocolName) {
        this.protocolName = protocolName;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.input = new BufferedInputStream(socket.getInputStream());
        this.input.mark(2);
        this.output = socket.getOutputStream();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ServerThread(Socket socket, String protocolName, long timeout, long life, ServerThreadPool pool) {
        this();
        this.socket = socket;
        this.protocolName = protocolName;
        this.timeout = timeout;
        this.life = life;
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerThread() {
        Long l = instances;
        synchronized (l) {
            this.id = instances;
            instances = new Long(instances + 1L);
            this.clientsHandled = 0L;
        }
    }

    public static class NDCIdentity {
        private long threadId;
        private long clientsHandled;
        private Socket socket;

        public NDCIdentity(ServerThread thread) {
            this.threadId = thread.getId();
            this.clientsHandled = thread.getClientsHandled();
            this.socket = thread.getSocket();
        }

        public String toString() {
            return "addr=" + this.socket.getInetAddress().getHostAddress() + ",thread=" + this.threadId + ",clients=" + this.clientsHandled;
        }
    }
}

