/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4;

import java.util.ArrayList;
import java.util.List;
import org.buni.meldware.mail.api.FolderBody;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.BodyStructurePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyStructure {
    private List<BodyStructurePart> parts;
    private String messagetype;
    private String boundry;
    private String language;

    public BodyStructure(FolderMessage md) {
        List bodies = md.getBody();
        String messageType = md.getHeader("Content-Type").split(";")[0].trim();
        String boundry = md.getHeader("Boundary");
        String language = null;
        this.construct(messageType, boundry, language, bodies);
    }

    public BodyStructure(String messagetype, String boundry, String language, List<FolderBody> bodies) {
        this.construct(messagetype, boundry, language, bodies);
    }

    public void construct(String messagetype, String boundry, String language, List<FolderBody> bodies) {
        this.messagetype = messagetype;
        this.boundry = boundry;
        this.language = language;
        this.parts = new ArrayList<BodyStructurePart>(bodies.size());
        int i = 0;
        while (i < bodies.size()) {
            this.parts.add(new BodyStructurePart(bodies.get(i)));
            ++i;
        }
    }

    public String toString() {
        String bodystr = "(BODYSTRUCTURE ";
        int b = 0;
        while (b < this.parts.size()) {
            BodyStructurePart pt = this.parts.get(b);
            bodystr = String.valueOf(bodystr) + "(\"" + pt.getContentType() + "\"";
            bodystr = String.valueOf(bodystr) + " \"" + pt.getContentSubtype() + "\"";
            int ctpsize = pt.getContentTypeParams() != null ? pt.getContentTypeParams().size() : 0;
            int i = 0;
            while (i < ctpsize) {
                bodystr = i == 0 ? String.valueOf(bodystr) + " (" : String.valueOf(bodystr) + " ";
                String[] ctp = pt.getContentTypeParams().get(i).split("=");
                String key = ctp[0];
                String val = ctp[1];
                bodystr = String.valueOf(bodystr) + "\"" + key + "\" " + "\"" + val + "\"";
                if (i == ctpsize - 1) {
                    bodystr = String.valueOf(bodystr) + ")";
                }
                ++i;
            }
            if (ctpsize == 0) {
                bodystr = String.valueOf(bodystr) + " NIL";
            }
            bodystr = String.valueOf(bodystr) + " NIL NIL";
            bodystr = String.valueOf(bodystr) + " \"" + pt.getEncoding() + "\"";
            bodystr = String.valueOf(bodystr) + " " + pt.getBodySize();
            bodystr = String.valueOf(bodystr) + " " + pt.getLineCount();
            if (pt.getContentDisposition() != null) {
                bodystr = String.valueOf(bodystr) + " (" + pt.getContentDisposition();
                int cdpsize = pt.getContentDispositionParams().size();
                int i2 = 0;
                while (i2 < cdpsize) {
                    bodystr = i2 == 0 ? String.valueOf(bodystr) + " (" : String.valueOf(bodystr) + " ";
                    String[] cdp = pt.getContentDispositionParams().get(i2).split("=");
                    String key = cdp[0];
                    String val = cdp[1];
                    bodystr = String.valueOf(bodystr) + "\"" + key + "\" " + "\"" + val + "\"";
                    if (i2 == cdpsize - 1) {
                        bodystr = String.valueOf(bodystr) + ")";
                    }
                    ++i2;
                }
                if (cdpsize == 0) {
                    bodystr = String.valueOf(bodystr) + " NIL";
                }
                bodystr = String.valueOf(bodystr) + ")";
            } else {
                bodystr = String.valueOf(bodystr) + " NIL";
            }
            bodystr = String.valueOf(bodystr) + " NIL NIL)";
            ++b;
        }
        if (this.parts.size() > 1) {
            bodystr = this.messagetype != null ? String.valueOf(bodystr) + " " + this.messagetype : String.valueOf(bodystr) + " NIL";
            bodystr = this.boundry != null ? String.valueOf(bodystr) + " (\"boundary\" \"" + this.boundry + "\")" : String.valueOf(bodystr) + " NIL";
            bodystr = String.valueOf(bodystr) + " NIL NIL)";
        } else {
            bodystr = String.valueOf(bodystr) + ")";
        }
        return bodystr;
    }
}

