/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.IMAP4OutputStream;
import org.buni.meldware.mail.imap4.commands.fetch.BodyPart;
import org.buni.meldware.mail.imap4.commands.fetch.FetchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyPartRequest
extends FetchPart {
    String _name;
    private BodyPart.Type _type = BodyPart.Type.ALL;
    boolean _peek = false;
    private final List<String> _parts = new ArrayList<String>();
    private final List<Integer> address = new ArrayList<Integer>();
    int _rangeStart = -1;
    int _rangeLength = -1;

    public String getName() {
        return this._name;
    }

    public BodyPart.Type getType() {
        return this._type;
    }

    public boolean getPeek() {
        return this._peek;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(BodyPart.Type type) {
        this._type = type;
    }

    public void setPeek(boolean peek) {
        this._peek = peek;
    }

    public void addPart(String part) {
        this._parts.add(part);
    }

    public boolean hasRange() {
        return this._rangeStart >= 0 && this._rangeLength > 0;
    }

    public int getRangeStart() {
        return this._rangeStart;
    }

    public int getRangeLength() {
        return this._rangeLength;
    }

    public void setRange(String start, String length) {
        try {
            this._rangeStart = Integer.parseInt(start);
            this._rangeLength = Integer.parseInt(length);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setRange(int start, int length) {
        this._rangeStart = start;
        this._rangeLength = length;
    }

    public Iterator getPartIterator() {
        return this._parts.iterator();
    }

    public List<String> getParts() {
        return this._parts;
    }

    public void appendAddressId(int i) {
        this.address.add(i);
    }

    public void appendAddressId(Integer i) {
        this.address.add(i);
    }

    public List<Integer> getAddress() {
        return this.address;
    }

    @Override
    public void fetch(FolderMessage msg, IMAP4OutputStream out) {
        BodyPart bPart = new BodyPart();
        bPart.fetch(msg, this, out);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this._name);
        result.append("[");
        result.append(ArrayUtil.join(this.address, (String)"."));
        if (this.address.size() > 0 && this._type != BodyPart.Type.ALL) {
            result.append(".");
        }
        if (this._type != null) {
            switch (this._type) {
                case HEADER_FIELDS: {
                    result.append("HEADER.FIELDS");
                    break;
                }
                case HEADER_FIELDS_NOT: {
                    result.append("HEADER.FIELDS.NOT");
                    break;
                }
                case ALL: {
                    break;
                }
                default: {
                    result.append((Object)this._type);
                }
            }
        }
        if (this._parts != null && this._parts.iterator().hasNext()) {
            result.append(" (");
            Iterator i = this.getPartIterator();
            while (i.hasNext()) {
                result.append("\"" + i.next().toString().toUpperCase() + "\"");
                if (!i.hasNext()) continue;
                result.append(' ');
            }
            result.append(")");
        }
        result.append("]");
        if (this.hasRange()) {
            result.append("<");
            result.append(this._rangeStart);
            result.append(".");
            result.append(this._rangeLength);
            result.append(">");
        }
        return result.toString();
    }
}

