/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.buni.meldware.mail.api.FolderFilter;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.api.Range;
import org.buni.meldware.mail.api.SearchKey;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.FolderMessageProxy;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.mailbox.MessageDataUtil;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.message.MailCreateAdapter;
import org.buni.meldware.mail.message.MailCreateListener;
import org.buni.meldware.mail.util.io.Copier;
import org.buni.meldware.mail.util.io.ExactSizeCopier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderProxy
implements org.buni.meldware.mail.api.Folder {
    private final Folder folder;
    private final MailboxService service;
    private int[] uids;
    private int maxUid = -1;

    public FolderProxy(MailboxService service, Folder folder) {
        this.service = service;
        this.folder = folder;
    }

    public List<org.buni.meldware.mail.api.Folder> getFolders() {
        Collection fs = this.folder.getFolders();
        ArrayList<org.buni.meldware.mail.api.Folder> folders = new ArrayList<org.buni.meldware.mail.api.Folder>(fs.size());
        for (Folder f : fs) {
            folders.add(new FolderProxy(this.service, f));
        }
        return folders;
    }

    public long getId() {
        return this.folder.getId();
    }

    public List<FolderMessage> getMessages() {
        List<MessageData> mds = this.service.getMailListForFolder(this.folder, false);
        ArrayList<FolderMessage> messages = new ArrayList<FolderMessage>();
        for (MessageData md : mds) {
            messages.add(new FolderMessageProxy(this.service, md));
        }
        this.uids = null;
        return messages;
    }

    private int getUid(int[] uids, int seqNum) {
        int uid = seqNum > uids.length ? Integer.MAX_VALUE : (seqNum < 1 ? uids[0] : uids[seqNum - 1]);
        return uid;
    }

    public List<FolderMessage> getMessages(boolean isUid, Range[] ranges) {
        Range[] uidRanges;
        if (!isUid) {
            int[] uids = this.getUids();
            uidRanges = new Range[ranges.length];
            int i = 0;
            while (i < ranges.length) {
                int minUid = this.getUid(uids, ranges[i].getMin());
                int maxUid = this.getUid(uids, ranges[i].getMax());
                uidRanges[i] = new Range(true, minUid, maxUid);
                ++i;
            }
        } else {
            uidRanges = ranges;
        }
        List<MessageData> mds = this.service.getMessages(this.folder, uidRanges, true);
        ArrayList<FolderMessage> messages = new ArrayList<FolderMessage>(mds.size());
        for (MessageData md : mds) {
            messages.add(new FolderMessageProxy(this.service, md));
        }
        return messages;
    }

    public void copy(org.buni.meldware.mail.api.Folder target, boolean isUid, Range[] ranges) {
        List<MessageData> mds = this.service.getMailListForFolder(this.folder, true);
        if (isUid) {
            for (MessageData md : mds) {
                Range[] rangeArray = ranges;
                int n = 0;
                int n2 = rangeArray.length;
                while (n < n2) {
                    Range range = rangeArray[n];
                    if ((long)range.getMin() <= md.getId() && (long)range.getMax() >= md.getId()) {
                        this.service.copy(target.getId(), md);
                    }
                    ++n;
                }
            }
        } else {
            int i = 0;
            while (i < mds.size()) {
                int seqNum = i + 1;
                MessageData md = mds.get(i);
                Range[] rangeArray = ranges;
                int n = 0;
                int n3 = rangeArray.length;
                while (n < n3) {
                    Range range = rangeArray[n];
                    if (range.getMin() <= seqNum && range.getMax() >= seqNum) {
                        this.service.copy(target.getId(), md);
                    }
                    ++n;
                }
                ++i;
            }
        }
    }

    public String getName() {
        return this.folder.getName();
    }

    public String[] getPath() {
        return this.service.getPathFor(this.folder).split("/");
    }

    public void rename(String[] path) {
        this.service.moveFolder(this.folder, path);
    }

    public int getMessageCount() {
        return this.service.getMailCountForFolder(this.folder);
    }

    public int getMaxUid() {
        int newMaxUid = this.service.getMaxUid(this.folder);
        if (newMaxUid != this.maxUid) {
            this.maxUid = newMaxUid;
            this.uids = null;
        }
        return this.maxUid;
    }

    public int getRecentCount() {
        return this.service.getRecentCountForFolder(this.folder);
    }

    public int getUnseenCount() {
        return this.service.getUnseenCountForFolder(this.folder);
    }

    public long getFirstUnseen() {
        return this.service.getFirstUnseen(this.folder);
    }

    public long getLikelyUID() {
        return this.service.getLikelyUID(this.folder);
    }

    public List<org.buni.meldware.mail.api.Folder> getSubFolders(String[] path, FolderFilter filter) {
        ArrayList<org.buni.meldware.mail.api.Folder> subfolders = new ArrayList<org.buni.meldware.mail.api.Folder>();
        for (Folder f : this.service.getSubfolders(this.folder, path, filter)) {
            subfolders.add(new FolderProxy(this.service, f));
        }
        return subfolders;
    }

    public void append(InputStream in, int size, List<String> flags, Date timestamp) {
        IMAP4MailCreateAdapter mcl = new IMAP4MailCreateAdapter(size);
        Mail m = Mail.create((MailBodyManager)this.service.getBodyManager(), (InputStream)in, (MailCreateListener)mcl);
        MessageDataUtil mdu = new MessageDataUtil(this.service.getBodyManager());
        MessageData md = mdu.create(m, true);
        this.service.createMail(this.folder, md);
    }

    public List<Integer> expunge(boolean returnUids) {
        return this.service.expunge(this.folder, returnUids);
    }

    public int[] getUids() {
        if (this.uids == null) {
            this.uids = this.service.getUids(this.folder);
        }
        return this.uids;
    }

    public int getSeqNum(int uid) {
        return Arrays.binarySearch(this.getUids(), uid) + 1;
    }

    public Collection<Integer> search(SearchKey searchKey) {
        return new ArrayList<Integer>(0);
    }

    private static class IMAP4MailCreateAdapter
    extends MailCreateAdapter {
        private long size;

        public IMAP4MailCreateAdapter(long size) {
            this.size = size;
        }

        public Copier getCopier() {
            long bodySize = this.size - (long)this.getBytesRead();
            return new ExactSizeCopier(bodySize);
        }

        public MailAddress getFrom() {
            MailAddress from;
            String[] fromArr = this.getMailHeaders().getHeader("From");
            if (fromArr != null && fromArr.length > 0) {
                String sfrom = this.getMailHeaders().getHeader("From")[0];
                from = MailAddress.parseSMTPStyle((String)sfrom);
            } else {
                from = MailAddress.parseSMTPStyle((String)"");
            }
            return from;
        }

        public MailAddress[] getTo() {
            String[] ato = this.getMailHeaders().getHeader("To");
            MailAddress[] to = new MailAddress[ato.length];
            if (ato != null) {
                int i = 0;
                while (i < ato.length) {
                    to[i] = MailAddress.parseSMTPStyle((String)ato[i]);
                    ++i;
                }
            }
            return to;
        }
    }
}

