/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.buni.meldware.mail.mailbox.MessageBody;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.message.Body;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.util.TextUtil;
import org.buni.meldware.mail.util.io.Copier;
import org.buni.meldware.mail.util.io.IOUtil;
import org.buni.panto.BodyHeader;
import org.buni.panto.ContentHandler;
import org.buni.panto.ContentType;

public class PantoContentHandler
implements ContentHandler {
    MessageData root = null;
    MyStack<MessageBody> bodyStack = new MyStack();
    StringBuilder currentHeader = new StringBuilder();
    boolean isMessage = false;
    private MailBodyManager mgr;
    private Copier copier;

    public PantoContentHandler(MailBodyManager mgr, Copier copier) {
        this.mgr = mgr;
        this.copier = copier;
    }

    public MessageData getMessage() {
        return this.root;
    }

    public void startMessage() {
        this.isMessage = true;
        if (this.root == null) {
            this.root = new MessageData();
            this.root.setMime(true);
        }
    }

    public void endMessage() {
        this.isMessage = false;
    }

    public void startHeader() {
        int len = this.currentHeader.length();
        if (len > 0) {
            this.currentHeader.delete(0, len);
        }
    }

    public void field(String fieldData) {
        if (fieldData.trim().length() > 0) {
            this.currentHeader.append(TextUtil.trimRight((String)fieldData));
            this.currentHeader.append("\r\n");
        }
    }

    public void endHeader() {
        if (this.isMessage) {
            if (this.bodyStack.isEmpty()) {
                this.root.setHeader(this.currentHeader.toString());
            } else {
                this.bodyStack.peek().setHeader(this.currentHeader.toString());
            }
        } else {
            this.bodyStack.peek().setMimeheader(this.currentHeader.toString());
        }
    }

    public void startMultipart(BodyHeader header) {
        if (!this.bodyStack.isEmpty()) {
            MessageBody mb = this.bodyStack.peek();
            mb.setMimeType(this.getMimeType(header.getContentType()));
            mb.setBoundary(header.getContentType().getBoundary());
        }
    }

    public void startBodyPart() {
        this.isMessage = false;
        MessageBody mb = new MessageBody();
        mb.setBodyless(true);
        this.bodyStack.push(mb);
    }

    public void body(BodyHeader bd, InputStream is) throws IOException {
        MessageBody mb;
        Body body = this.mgr.createMailBody();
        this.mgr.read(body, is, this.copier);
        if (this.isMessage) {
            mb = new MessageBody();
            if (this.bodyStack.isEmpty()) {
                this.root.addMessageBody(mb);
            } else {
                this.bodyStack.peek().addMessageBody(mb);
            }
        } else {
            mb = this.bodyStack.peek();
        }
        mb.setBodyId(body.getStoreId().longValue());
        mb.setSize((int)body.getSize());
        mb.setBodyless(false);
        mb.setMimeType(this.getMimeType(bd.getContentType()));
    }

    private String getMimeType(ContentType ct) {
        return String.valueOf(ct.getType()) + "/" + ct.getSubType();
    }

    public void endBodyPart() {
        MessageBody body = this.bodyStack.pop();
        if (this.bodyStack.isEmpty()) {
            this.root.addMessageBody(body);
        } else {
            this.bodyStack.peek().addMessageBody(body);
        }
    }

    public void endMultipart() {
    }

    public void epilogue(InputStream is) throws IOException {
        String epilogue = IOUtil.toString((InputStream)is, (String)"US-ASCII");
        if (this.bodyStack.isEmpty()) {
            this.root.setEpilogue(epilogue);
        } else {
            this.bodyStack.peek().setEpilogue(epilogue);
        }
    }

    public void preamble(InputStream is) throws IOException {
        String preamble = IOUtil.toString((InputStream)is, (String)"US-ASCII");
        if (this.bodyStack.isEmpty()) {
            this.root.setMimePreamble(preamble);
        } else {
            this.bodyStack.peek().setPreamble(preamble);
        }
    }

    public void raw(InputStream is) throws IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyStack<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;

        private MyStack() {
        }

        public E pop() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(this.size() - 1);
        }

        public E peek() {
            if (this.isEmpty()) {
                return null;
            }
            return this.get(this.size() - 1);
        }

        public void push(E e) {
            this.add(e);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

