/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.buni.meldware.mail.mailbox.search.SearchContext;
import org.buni.meldware.mail.mailbox.search.SearchQuery;
import org.buni.meldware.mail.mailbox.search.SearchValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBQLSearchQuery
extends SearchQuery {
    private SearchValue value;
    private String field;
    private Operator oper;

    public EJBQLSearchQuery(String field, Operator oper, SearchValue value) {
        this.field = field;
        this.oper = oper;
        this.value = value;
    }

    public String getClause() {
        return String.format("m.%s %s :field", this.field, this.getOp(), this.field);
    }

    @Override
    public Set<Long> getResults(SearchContext context) {
        String queryStr = "select m.id from MessageData m where m.folder.id = :folder and (%s)";
        Query q = context.getEntityManager().createQuery(String.format(queryStr, this.getClause()));
        q.setParameter("folder", (Object)context.getFolderId());
        this.value.setParameter("field", q);
        List results = q.getResultList();
        HashSet<Long> values = new HashSet<Long>();
        for (Object o : results) {
            Long l = (Long)o;
            values.add(l);
        }
        return values;
    }

    public String getOp() {
        switch (this.oper) {
            case EQ: {
                return "=";
            }
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
        }
        throw new RuntimeException("Unknown Operator: " + (Object)((Object)this.oper));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        EQ,
        LT,
        LE,
        GT,
        GE;

    }
}

