/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox.search;

import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.api.SearchKey;
import org.buni.meldware.mail.mailbox.search.BooleanSearchValue;
import org.buni.meldware.mail.mailbox.search.EJBQLSearchQuery;
import org.buni.meldware.mail.mailbox.search.SearchQuery;
import org.buni.meldware.mail.mailbox.search.SearchValue;
import org.buni.meldware.mail.mailbox.search.StringSearchValue;

public class SearchQueryFactory {
    public SearchQuery create(SearchKey key) {
        switch (key.getPartName()) {
            case ANSWERED: {
                return this.createEJBQL("answered", key);
            }
            case BCC: {
                return this.createEJBQL("bcc", key);
            }
        }
        throw new MailException("Unknown Query type: %s", new Object[]{key.getPartName()});
    }

    public SearchQuery createEJBQL(String field, SearchKey key) {
        SearchValue v = this.createValue(key);
        return new EJBQLSearchQuery(field, EJBQLSearchQuery.Operator.EQ, v);
    }

    public SearchValue createValue(SearchKey key) {
        switch (key.getType()) {
            case BOOLEAN: {
                return new BooleanSearchValue((Boolean)key.getValue());
            }
            case STRING: {
                return new StringSearchValue((String)key.getValue());
            }
        }
        return null;
    }
}

