/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.userrepository.UserRepository;
import org.jboss.logging.Logger;

public class CmdPASS
extends AbstractCommand
implements POP3Handler {
    public static final String COMMAND = "PASS";
    private static final Logger log = Logger.getLogger(CmdPASS.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException {
        log.debug((Object)"PASS command handler called");
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        String[] arguments = request.getArguments();
        if (this.verifyState(protocol, writer, 0) && this.verifyArgumentCount(arguments, writer, 1)) {
            String username = protocol.getUsername();
            String password = arguments[0];
            password.trim();
            if (username == null) {
                writer.println("-ERR USER command must be issued before PASS.");
            } else if (password.length() == 0) {
                writer.println("-ERR Invalid password.");
            } else if (password.length() > 0) {
                if (!((UserRepository)protocol.getProperty("UserRepository")).test(username, password)) {
                    writer.println("-ERR Authentication failed");
                    protocol.setState("USER", null);
                } else {
                    try {
                        Mailbox mailbox = protocol.getMailboxForUser(username);
                        if (mailbox == null) {
                            mailbox = protocol.getMailboxService().createMailbox(username);
                        }
                        if (protocol.lock((Folder)mailbox)) {
                            protocol.setUsername(username);
                            protocol.setMailbox(mailbox);
                            protocol.setState(1);
                            writer.println("+OK");
                        } else {
                            writer.println("-ERR Mailbox locked.");
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error getting MailboxMBean: " + e), (Throwable)e);
                        writer.println("-ERR Service Unavailable");
                    }
                }
            }
        }
        writer.flush();
        return response;
    }
}

