/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.buni.meldware.mail.userrepository.UserRepository;
import org.buni.meldware.mail.util.Base64;
import org.jboss.logging.Logger;

public class CmdAUTH
implements SMTPHandler,
SMTPConstants {
    private static final Logger jblog = Logger.getLogger(CmdAUTH.class);
    public static final String COMMAND = "AUTH";
    public static final String USERNAME = "Username:";
    public static final String PASSWORD = "Password:";
    private static final String USERNAME_BASE64 = CmdAUTH.unsafeEncode("Username:");
    private static final String PASSWORD_BASE64 = CmdAUTH.unsafeEncode("Password:");

    public SMTPResponse handleRequest(OutputStream out, SMTPRequest request, Protocol protocol) throws IOException {
        jblog.debug((Object)"AUTH command handler called");
        String authType = this.getAuthType(request.arguments());
        jblog.debug((Object)("AuthType = " + authType));
        SMTPProtocolInstance smtpProtocol = (SMTPProtocolInstance)protocol;
        SMTPResponse response = new SMTPResponse(request, out, protocol);
        PrintWriter writer = response.getWriter();
        boolean requireTlsForAuth = protocol.getPropertyBool("RequireTlsForAuth");
        if (smtpProtocol.getState("USER") != null) {
            writer.println("503 User has previously authenticated.  Further authentication is not required!");
        } else if (authType == null) {
            writer.println("501 Usage: AUTH (authentication type) <challenge>");
        } else if (requireTlsForAuth && !smtpProtocol.isSecure()) {
            writer.println("538 Encryption required for requested authentication mechanism");
        } else {
            String initialResponse = null;
            if (authType.trim().indexOf(" ") > 0) {
                initialResponse = authType.trim().substring(authType.trim().indexOf(" ") + 1);
            }
            if (!authType.trim().equals("LOGIN") && authType.indexOf(" ") != -1) {
                authType = authType.substring(0, authType.indexOf(" "));
            }
            if ((authType = authType.trim().toUpperCase(Locale.US)).equals("PLAIN")) {
                this.doPlainAuth(initialResponse, smtpProtocol, request, writer);
            } else if (authType.equals("LOGIN")) {
                this.doLoginAuth(initialResponse, smtpProtocol, request, writer);
            } else {
                this.doUnknownAuth(authType, initialResponse, writer);
            }
        }
        writer.flush();
        return response;
    }

    private void doPlainAuth(String initialResponse, SMTPProtocolInstance protocol, SMTPRequest request, PrintWriter writer) throws IOException {
        String userpass = null;
        String user = null;
        String pass = null;
        if (initialResponse == null) {
            writer.println("334 OK. Continue authentication");
            writer.flush();
            userpass = protocol.readResponse(request);
        } else {
            userpass = initialResponse.trim();
        }
        try {
            if (userpass != null) {
                userpass = Base64.decodeAsString((String)userpass);
                StringTokenizer authTokenizer = new StringTokenizer(userpass, "\u0000");
                user = authTokenizer.nextToken();
                pass = authTokenizer.nextToken();
                authTokenizer = null;
            }
        }
        catch (Exception exception) {
            jblog.warn((Object)"**BASE 64 caused exception in doPlainAuth");
        }
        if (jblog.isDebugEnabled()) {
            jblog.debug((Object)("user=" + user + " pass=" + pass));
        }
        if (user == null || pass == null) {
            writer.println("501 Could not decode user and password for AUTH PLAIN");
        } else if (((UserRepository)protocol.getProperty("UserRepository")).test(user, pass)) {
            protocol.setState("USER", user);
            writer.println("235 Authentication Successful");
            jblog.debug((Object)"AUTH method PLAIN succeeded");
        } else {
            writer.println("535 Authentication Failed");
            jblog.debug((Object)"AUTH method PLAIN failed");
        }
    }

    private void doLoginAuth(String initialResponse, SMTPProtocolInstance smtpProtocol, SMTPRequest request, PrintWriter writer) throws IOException {
        String user = null;
        String password = null;
        if (initialResponse == null) {
            writer.println("334 " + USERNAME_BASE64);
            writer.flush();
            user = smtpProtocol.readResponse(request);
        } else {
            user = initialResponse.trim();
        }
        try {
            user = Base64.decodeAsString((String)user);
        }
        catch (Exception exception) {
            user = null;
        }
        writer.println("334 " + PASSWORD_BASE64);
        writer.flush();
        password = smtpProtocol.readResponse(request);
        try {
            password = Base64.decodeAsString((String)password);
        }
        catch (Exception exception) {
            password = null;
        }
        if (user == null || password == null) {
            writer.println("501 Could not decode user and password");
        } else if (((UserRepository)smtpProtocol.getProperty("UserRepository")).test(user, password)) {
            smtpProtocol.setState("USER", user);
            writer.println("235 Authentication Successful");
            jblog.debug((Object)"AUTH method Login succeeded");
        } else {
            writer.println("535 Authentication Failed");
            jblog.warn((Object)"AUTH method LOGIN failed");
            jblog.warn((Object)("user was " + user));
        }
        writer.flush();
    }

    private void doUnknownAuth(String authType, String initialResponse, PrintWriter writer) {
    }

    private String getAuthType(Iterator iter) {
        String remote = null;
        if (iter.hasNext() && iter != null) {
            remote = (String)iter.next();
        }
        return remote;
    }

    private static String unsafeEncode(String src) {
        String retval = null;
        try {
            retval = Base64.encodeAsString((String)src);
        }
        catch (Exception exception) {
            throw new RuntimeException("CODE ERROR, BASE64 failed");
        }
        return retval;
    }
}

