/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.jboss.logging.Logger;

public class RequireSTARTTLSProxy
implements SMTPHandler {
    private SMTPHandler handler;
    private static final Logger jblog = Logger.getLogger(RequireSTARTTLSProxy.class);

    public RequireSTARTTLSProxy(SMTPHandler handler) {
        this.handler = handler;
    }

    public SMTPResponse handleRequest(OutputStream out, SMTPRequest request, Protocol protocol) throws IOException {
        SMTPProtocolInstance smtpProtocol = (SMTPProtocolInstance)protocol;
        if (this.isTlsRequired(smtpProtocol)) {
            SMTPResponse response = new SMTPResponse(request, out, protocol);
            PrintWriter writer = response.getWriter();
            jblog.warn((Object)"Sending 530 Must issue a STARTTLS command first");
            writer.println("530 Must issue a STARTTLS command first");
            writer.flush();
            return response;
        }
        return this.handler.handleRequest(out, request, protocol);
    }

    private boolean isTlsRequired(SMTPProtocolInstance protocol) {
        boolean requireTls = protocol.getPropertyBool("RequireTls");
        boolean isSecure = protocol.isSecure();
        return requireTls && !isSecure;
    }
}

