/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import java.util.HashMap;
import java.util.Map;
import org.buni.meldware.mail.smtp.handlers.CmdAUTH;
import org.buni.meldware.mail.smtp.handlers.CmdDATA;
import org.buni.meldware.mail.smtp.handlers.CmdEHLO;
import org.buni.meldware.mail.smtp.handlers.CmdEXPN;
import org.buni.meldware.mail.smtp.handlers.CmdHELO;
import org.buni.meldware.mail.smtp.handlers.CmdHELP;
import org.buni.meldware.mail.smtp.handlers.CmdMAIL;
import org.buni.meldware.mail.smtp.handlers.CmdNOOP;
import org.buni.meldware.mail.smtp.handlers.CmdQUIT;
import org.buni.meldware.mail.smtp.handlers.CmdRCPT;
import org.buni.meldware.mail.smtp.handlers.CmdRSET;
import org.buni.meldware.mail.smtp.handlers.CmdSTARTTLS;
import org.buni.meldware.mail.smtp.handlers.CmdVRFY;
import org.buni.meldware.mail.smtp.handlers.RequireSTARTTLSProxy;

public class SMTPHandlers {
    private static Map handlers;

    public static Map instance() {
        if (handlers == null) {
            SMTPHandlers.constructHandlers();
        }
        return handlers;
    }

    private static synchronized void constructHandlers() {
        if (handlers == null) {
            handlers = new HashMap();
            handlers.put("HELO", new RequireSTARTTLSProxy(new CmdHELO()));
            handlers.put("EHLO", new CmdEHLO());
            handlers.put("QUIT", new CmdQUIT());
            handlers.put("MAIL", new RequireSTARTTLSProxy(new CmdMAIL()));
            handlers.put("RCPT", new RequireSTARTTLSProxy(new CmdRCPT()));
            handlers.put("AUTH", new RequireSTARTTLSProxy(new CmdAUTH()));
            handlers.put("DATA", new RequireSTARTTLSProxy(new CmdDATA()));
            handlers.put("STARTTLS", new CmdSTARTTLS());
            handlers.put("RSET", new CmdRSET());
            handlers.put("NOOP", new CmdNOOP());
            handlers.put("HELP", new CmdHELP());
            handlers.put("VRFY", new CmdVRFY());
            handlers.put("EXPN", new CmdEXPN());
        }
    }
}

