/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.DBStoreMBean;
import org.buni.meldware.mail.store.StoreException;

public abstract class DBStore
extends AbstractStore
implements DBStoreMBean {
    private String dataSource = null;
    private DataSource ds = null;
    private boolean disconnected = false;

    public DataSource getDS() {
        return this.ds;
    }

    public void setDS(DataSource ds) {
        this.ds = ds;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public boolean getDisconnected() {
        return this.disconnected;
    }

    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    public void init() throws StoreException {
        if (this.ds == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.ds = (DataSource)ctx.lookup(this.dataSource);
            }
            catch (NamingException namingException) {
                throw new StoreException("Unable to locate database: " + this.dataSource);
            }
        }
    }

    public Connection getConnection() throws StoreException {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException sQLException) {
            throw new StoreException("Unable to getConnection");
        }
    }
}

