/*
 * Decompiled with CFR 0.152.
 */
package org.buraktamturk.loadingview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import org.buraktamturk.loadingview.LoadingConfiguration;
import org.buraktamturk.loadingview.R;

public class LoadingView
extends ViewSwitcher {
    InnerView loadingView;
    boolean disloading;

    public LoadingView(Context context) {
        super(context);
        this.init(null);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (!this.isInEditMode()) {
            this.loadingView = new InnerView(this.getContext());
            this.addView((View)this.loadingView);
            if (attrs != null) {
                String str;
                LoadingConfiguration c = LoadingConfiguration.getDefault();
                TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LoadingView, 0, 0);
                this.disloading = a.getBoolean(R.styleable.LoadingView_lv_loading, c.isLoading);
                int color = a.getColor(R.styleable.LoadingView_lv_color, c.textColor == null ? 0 : c.textColor);
                if (color != 0) {
                    ((TextView)this.loadingView.findViewById(R.id.LoadingView_text)).setTextColor(color);
                }
                if ((str = a.getString(R.styleable.LoadingView_lv_title)) == null) {
                    str = c.resourceStringId != -1 ? this.getContext().getString(c.resourceStringId) : c.loading;
                }
                this.setText(str);
            }
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (this.getChildCount() == 2) {
            this.setLoading(this.disloading);
        }
    }

    public boolean getLoading() {
        return this.getCurrentView() == this.loadingView;
    }

    public void setLoading(boolean state) {
        if (this.getCurrentView() == this.loadingView != state) {
            this.showNext();
        }
    }

    public void setText(int stringResourceId) {
        this.loadingView.setText(stringResourceId);
    }

    public void setText(String loadingText) {
        this.loadingView.setText(loadingText);
    }

    public static class InnerView
    extends LinearLayout {
        public InnerView(Context context) {
            super(context);
            this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.setOrientation(0);
            LayoutInflater.from((Context)context).inflate(R.layout.loadingview_layout, (ViewGroup)this, true);
        }

        public void setText(int stringResourceId) {
            ((TextView)this.findViewById(R.id.LoadingView_text)).setVisibility(0);
            ((TextView)this.findViewById(R.id.LoadingView_text)).setText(stringResourceId);
        }

        public void setText(String loadingText) {
            if (loadingText == null) {
                ((TextView)this.findViewById(R.id.LoadingView_text)).setVisibility(8);
            } else {
                ((TextView)this.findViewById(R.id.LoadingView_text)).setVisibility(0);
                ((TextView)this.findViewById(R.id.LoadingView_text)).setText((CharSequence)loadingText);
            }
        }
    }
}

