// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** A utility which keeps track of a collection of asynchronous tasks
 * 
 *  This can be used to provide structured concurrency for asynchronous development.
 *  A task group created at a high level can be distributed amongst low level components
 *  which register work to be completed.  The high level job can then wait for all work
 *  to be completed before cleaning up. */
@Namespace("arrow::util") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class AsyncTaskGroup extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AsyncTaskGroup() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AsyncTaskGroup(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AsyncTaskGroup(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AsyncTaskGroup position(long position) {
        return (AsyncTaskGroup)super.position(position);
    }
    @Override public AsyncTaskGroup getPointer(long i) {
        return new AsyncTaskGroup((Pointer)this).offsetAddress(i);
    }

  /** Add a task to be tracked by this task group
   * 
   *  If a previous task has failed then adding a task will fail
   * 
   *  If WaitForTasksToFinish has been called and the returned future has been marked
   *  completed then adding a task will fail. */
  public native @ByVal Status AddTask(@ByVal @Cast("std::function<arrow::Result<arrow::Future<> >()>*") Pointer task);
  /** Add a task that has already been started */
  
  ///
  ///
  ///
  public native @ByVal Status AddTask(@Const @ByRef Future task);
  /** Signal that top level tasks are done being added
   * 
   *  It is allowed for tasks to be added after this call provided the future has not yet
   *  completed.  This should be safe as long as the tasks being added are added as part
   *  of a task that is tracked.  As soon as the count of running tasks reaches 0 this
   *  future will be marked complete.
   * 
   *  Any attempt to add a task after the returned future has completed will fail.
   * 
   *  The returned future that will finish when all running tasks have finsihed. */
  
  ///
  ///
  public native @ByVal Future End();
  /** A future that will be finished after End is called and all tasks have completed
   * 
   *  This is the same future that is returned by End() but calling this method does
   *  not indicate that top level tasks are done being added.  End() must still be called
   *  at some point or the future returned will never finish.
   * 
   *  This is a utility method for workflows where the finish future needs to be
   *  referenced before all top level tasks have been queued. */
  public native @ByVal Future OnFinished();
}
