// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Options for the dictionary encode function */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class DictionaryEncodeOptions extends FunctionOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DictionaryEncodeOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DictionaryEncodeOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DictionaryEncodeOptions position(long position) {
        return (DictionaryEncodeOptions)super.position(position);
    }
    @Override public DictionaryEncodeOptions getPointer(long i) {
        return new DictionaryEncodeOptions((Pointer)this).offsetAddress(i);
    }

  /** Configure how null values will be encoded */
  public enum NullEncodingBehavior {
    /** The null value will be added to the dictionary with a proper index. */
    ENCODE(0),
    /** The null value will be masked in the indices array. */
    MASK(1);

      public final int value;
      private NullEncodingBehavior(int v) { this.value = v; }
      private NullEncodingBehavior(NullEncodingBehavior e) { this.value = e.value; }
      public NullEncodingBehavior intern() { for (NullEncodingBehavior e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  public DictionaryEncodeOptions(NullEncodingBehavior null_encoding/*=arrow::compute::DictionaryEncodeOptions::MASK*/) { super((Pointer)null); allocate(null_encoding); }
  private native void allocate(NullEncodingBehavior null_encoding/*=arrow::compute::DictionaryEncodeOptions::MASK*/);
  public DictionaryEncodeOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  public DictionaryEncodeOptions(@Cast("arrow::compute::DictionaryEncodeOptions::NullEncodingBehavior") int null_encoding/*=arrow::compute::DictionaryEncodeOptions::MASK*/) { super((Pointer)null); allocate(null_encoding); }
  private native void allocate(@Cast("arrow::compute::DictionaryEncodeOptions::NullEncodingBehavior") int null_encoding/*=arrow::compute::DictionaryEncodeOptions::MASK*/);
  @MemberGetter public static native byte kTypeName(int i);
  @MemberGetter public static native String kTypeName();
  public static native @ByVal DictionaryEncodeOptions Defaults();

  public native NullEncodingBehavior null_encoding_behavior(); public native DictionaryEncodeOptions null_encoding_behavior(NullEncodingBehavior setter);
}
