// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \}
 <p>
 *  \class MutableBuffer
 *  \brief A Buffer whose contents can be mutated. May or may not own its data. */
@Namespace("arrow") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class MutableBuffer extends ArrowBuffer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MutableBuffer(Pointer p) { super(p); }

  public MutableBuffer(@Cast("uint8_t*") BytePointer data, @Cast("const int64_t") long size) { super((Pointer)null); allocate(data, size); }
  private native void allocate(@Cast("uint8_t*") BytePointer data, @Cast("const int64_t") long size);
  public MutableBuffer(@Cast("uint8_t*") ByteBuffer data, @Cast("const int64_t") long size) { super((Pointer)null); allocate(data, size); }
  private native void allocate(@Cast("uint8_t*") ByteBuffer data, @Cast("const int64_t") long size);
  public MutableBuffer(@Cast("uint8_t*") byte[] data, @Cast("const int64_t") long size) { super((Pointer)null); allocate(data, size); }
  private native void allocate(@Cast("uint8_t*") byte[] data, @Cast("const int64_t") long size);

  public MutableBuffer(@Cast("uint8_t*") BytePointer data, @Cast("const int64_t") long size, @SharedPtr MemoryManager mm) { super((Pointer)null); allocate(data, size, mm); }
  private native void allocate(@Cast("uint8_t*") BytePointer data, @Cast("const int64_t") long size, @SharedPtr MemoryManager mm);
  public MutableBuffer(@Cast("uint8_t*") ByteBuffer data, @Cast("const int64_t") long size, @SharedPtr MemoryManager mm) { super((Pointer)null); allocate(data, size, mm); }
  private native void allocate(@Cast("uint8_t*") ByteBuffer data, @Cast("const int64_t") long size, @SharedPtr MemoryManager mm);
  public MutableBuffer(@Cast("uint8_t*") byte[] data, @Cast("const int64_t") long size, @SharedPtr MemoryManager mm) { super((Pointer)null); allocate(data, size, mm); }
  private native void allocate(@Cast("uint8_t*") byte[] data, @Cast("const int64_t") long size, @SharedPtr MemoryManager mm);

  public MutableBuffer(@SharedPtr ArrowBuffer parent, @Cast("const int64_t") long offset,
                  @Cast("const int64_t") long size) { super((Pointer)null); allocate(parent, offset, size); }
  private native void allocate(@SharedPtr ArrowBuffer parent, @Cast("const int64_t") long offset,
                  @Cast("const int64_t") long size);

  /** \brief Create buffer referencing typed memory with some length
   *  @param data [in] the typed memory as C array
   *  @param length [in] the number of values in the array
   *  @return a new shared_ptr<Buffer> */
}
