// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief A group of related tasks
 * 
 *  A TaskGroup executes tasks with the signature {@code Status()}.
 *  Execution can be serial or parallel, depending on the TaskGroup
 *  implementation.  When Finish() returns, it is guaranteed that all
 *  tasks have finished, or at least one has errored.
 * 
 *  Once an error has occurred any tasks that are submitted to the task group
 *  will not run.  The call to Append will simply return without scheduling the
 *  task.
 * 
 *  If the task group is parallel it is possible that multiple tasks could be
 *  running at the same time and one of those tasks fails.  This will put the
 *  task group in a failure state (so additional tasks cannot be run) however
 *  it will not interrupt running tasks.  Finish will not complete
 *  until all running tasks have finished, even if one task fails.
 * 
 *  Once a task group has finished new tasks may not be added to it.  If you need to start
 *  a new batch of work then you should create a new task group. */
@Namespace("arrow::internal") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class TaskGroup extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TaskGroup(Pointer p) { super(p); }

  /** Add a Status-returning function to execute.  Execution order is
   *  undefined.  The function may be executed immediately or later. */

  /** Wait for execution of all tasks (and subgroups) to be finished,
   *  or for at least one task (or subgroup) to error out.
   *  The returned Status propagates the error status of the first failing
   *  task (or subgroup). */
  
  ///
  ///
  public native @ByVal Status Finish();

  /** Returns a future that will complete the first time all tasks are finished.
   *  This should be called only after all top level tasks
   *  have been added to the task group.
   * 
   *  If you are using a TaskGroup asynchronously there are a few considerations to keep
   *  in mind.  The tasks should not block on I/O, etc (defeats the purpose of using
   *  futures) and should not be doing any nested locking or you run the risk of the tasks
   *  getting stuck in the thread pool waiting for tasks which cannot get scheduled.
   * 
   *  Primarily this call is intended to help migrate existing work written with TaskGroup
   *  in mind to using futures without having to do a complete conversion on the first
   *  pass. */
  public native @ByVal Future FinishAsync();

  /** The current aggregate error Status.  Non-blocking, useful for stopping early. */
  public native @ByVal Status current_status();

  /** Whether some tasks have already failed.  Non-blocking, useful for stopping early. */
  public native @Cast("bool") boolean ok();

  /** How many tasks can typically be executed in parallel.
   *  This is only a hint, useful for testing or debugging. */
  public native int parallelism();

  public static native @SharedPtr TaskGroup MakeSerial(@ByVal(nullValue = "arrow::StopToken::Unstoppable()") StopToken arg0);
  public static native @SharedPtr TaskGroup MakeSerial();
  public static native @SharedPtr TaskGroup MakeThreaded(Executor arg0,
                                                   @ByVal(nullValue = "arrow::StopToken::Unstoppable()") StopToken arg1);
  public static native @SharedPtr TaskGroup MakeThreaded(Executor arg0);
}
