// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class WeekOptions extends FunctionOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public WeekOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public WeekOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public WeekOptions position(long position) {
        return (WeekOptions)super.position(position);
    }
    @Override public WeekOptions getPointer(long i) {
        return new WeekOptions((Pointer)this).offsetAddress(i);
    }

  public WeekOptions(@Cast("bool") boolean week_starts_monday/*=true*/, @Cast("bool") boolean count_from_zero/*=false*/,
                         @Cast("bool") boolean first_week_is_fully_in_year/*=false*/) { super((Pointer)null); allocate(week_starts_monday, count_from_zero, first_week_is_fully_in_year); }
  private native void allocate(@Cast("bool") boolean week_starts_monday/*=true*/, @Cast("bool") boolean count_from_zero/*=false*/,
                         @Cast("bool") boolean first_week_is_fully_in_year/*=false*/);
  public WeekOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  @MemberGetter public static native byte kTypeName(int i);
  @MemberGetter public static native String kTypeName();
  public static native @ByVal WeekOptions Defaults();
  public static native @ByVal WeekOptions ISODefaults();
  public static native @ByVal WeekOptions USDefaults();

  /** What day does the week start with (Monday=true, Sunday=false) */
  public native @Cast("bool") boolean week_starts_monday(); public native WeekOptions week_starts_monday(boolean setter);
  /** Dates from current year that fall into last ISO week of the previous year return
   *  0 if true and 52 or 53 if false. */
  public native @Cast("bool") boolean count_from_zero(); public native WeekOptions count_from_zero(boolean setter);
  /** Must the first week be fully in January (true), or is a week that begins on
   *  December 29, 30, or 31 considered to be the first week of the new year (false)? */
  public native @Cast("bool") boolean first_week_is_fully_in_year(); public native WeekOptions first_week_is_fully_in_year(boolean setter);
}
