// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow.global;

import org.bytedeco.arrow_dataset.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

public class arrow_dataset extends org.bytedeco.arrow.presets.arrow_dataset {
    static { Loader.load(); }

// Targeting ..\..\arrow_dataset\StringOptional.java


// Targeting ..\..\arrow_dataset\CompressionTypeOptional.java


// Targeting ..\..\arrow_dataset\KeyOptional.java


// Targeting ..\..\arrow_dataset\FileFragmentVector.java


// Targeting ..\..\arrow_dataset\ScanTaskVector.java


// Targeting ..\..\arrow_dataset\StringUnorderedSet.java


// Parsed from arrow/util/iterator.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cassert>
// #include <functional>
// #include <memory>
// #include <tuple>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/functional.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/optional.h"
// #include "arrow/util/visibility.h"
// Targeting ..\..\arrow_dataset\TaggedRecordBatchIterator.java


// Targeting ..\..\arrow_dataset\EnumeratedRecordBatchIterator.java


// Targeting ..\..\arrow_dataset\FragmentIterator.java


// Targeting ..\..\arrow_dataset\ScanTaskIterator.java


// Targeting ..\..\arrow_dataset\TransformFinish.java


// Targeting ..\..\arrow_dataset\TransformSkip.java



/** \brief Transforms an iterator according to a transformer, returning a new Iterator.
 * 
 *  The transformer will be called on each element of the source iterator and for each
 *  call it can yield a value, skip, or finish the iteration.  When yielding a value the
 *  transformer can choose to consume the source item (the default, ready_for_next = true)
 *  or to keep it and it will be called again on the same value.
 * 
 *  This is essentially a more generic form of the map operation that can return 0, 1, or
 *  many values for each of the source items.
 * 
 *  The transformer will be exposed to the end of the source sequence
 *  (IterationTraits::End) in case it needs to return some penultimate item(s).
 * 
 *  Any invalid status returned by the transformer will be returned immediately. */

/** \brief Construct an Iterator which invokes a callable on Next() */

/** \brief Simple iterator which yields the elements of a std::vector */

/** \brief Simple iterator which yields *pointers* to the elements of a std::vector<T>.
 *  This is provided to support T where IterationTraits<T>::End is not specialized */

/** \brief MapIterator takes ownership of an iterator and a function to apply
 *  on every element. The mapped function is not allowed to fail. */

/** \brief MapIterator takes ownership of an iterator and a function to apply
 *  on every element. The mapped function is not allowed to fail. */
// Targeting ..\..\arrow_dataset\FilterIterator.java



/** \brief Like MapIterator, but where the function can fail or reject elements. */

/** \brief FlattenIterator takes an iterator generating iterators and yields a
 *  unified iterator that flattens/concatenates in a single stream. */

  // namespace arrow


// Parsed from arrow/util/async_generator.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <atomic>
// #include <cassert>
// #include <cstring>
// #include <deque>
// #include <limits>
// #include <queue>

// #include "arrow/util/async_util.h"
// #include "arrow/util/functional.h"
// #include "arrow/util/future.h"
// #include "arrow/util/io_util.h"
// #include "arrow/util/iterator.h"
// #include "arrow/util/mutex.h"
// #include "arrow/util/optional.h"
// #include "arrow/util/queue.h"
// #include "arrow/util/thread_pool.h"

// The methods in this file create, modify, and utilize AsyncGenerator which is an
// iterator of futures.  This allows an asynchronous source (like file input) to be run
// through a pipeline in the same way that iterators can be used to create pipelined
// workflows.
//
// In order to support pipeline parallelism we introduce the concept of asynchronous
// reentrancy. This is different than synchronous reentrancy.  With synchronous code a
// function is reentrant if the function can be called again while a previous call to that
// function is still running.  Unless otherwise specified none of these generators are
// synchronously reentrant.  Care should be taken to avoid calling them in such a way (and
// the utilities Visit/Collect/Await take care to do this).
//
// Asynchronous reentrancy on the other hand means the function is called again before the
// future returned by the function is marked finished (but after the call to get the
// future returns).  Some of these generators are async-reentrant while others (e.g.
// those that depend on ordered processing like decompression) are not.  Read the MakeXYZ
// function comments to determine which generators support async reentrancy.
//
// Note: Generators that are not asynchronously reentrant can still support readahead
// (\see MakeSerialReadaheadGenerator).
//
// Readahead operators, and some other operators, may introduce queueing.  Any operators
// that introduce buffering should detail the amount of buffering they introduce in their
// MakeXYZ function comments.

/** returning a future that completes when all have been visited */

/** \brief Wait for an async generator to complete, discarding results. */

/** \brief Collect the results of an async generator into a vector */

/** @see MakeMappedGenerator */

/** \brief Create a generator that will apply the map function to each element of
 *  source.  The map function is not called on the end token.
 * 
 *  Note: This function makes a copy of {@code map} for each item
 *  Note: Errors returned from the {@code map} function will be propagated
 * 
 *  If the source generator is async-reentrant then this generator will be also */

/** \brief Create a generator that will apply the map function to
 *  each element of source.  The map function is not called on the end
 *  token.  The result of the map function should be another
 *  generator; all these generators will then be flattened to produce
 *  a single stream of items.
 * 
 *  Note: This function makes a copy of {@code map} for each item
 *  Note: Errors returned from the {@code map} function will be propagated
 * 
 *  If the source generator is async-reentrant then this generator will be also */

/** @see MakeSequencingGenerator */

/** \brief Buffer an AsyncGenerator to return values in sequence order  ComesAfter
 *  and IsNext determine the sequence order.
 * 
 *  ComesAfter should be a BinaryPredicate that only returns true if a comes after b
 * 
 *  IsNext should be a BinaryPredicate that returns true, given {@code a} and {@code b}, only if
 *  {@code b} follows immediately after {@code a}.  It should return true given {@code initial_value} and
 *  {@code b} if {@code b} is the first item in the sequence.
 * 
 *  This operator will queue unboundedly while waiting for the next item.  It is intended
 *  for jittery sources that might scatter an ordered sequence.  It is NOT intended to
 *  sort.  Using it to try and sort could result in excessive RAM usage.  This generator
 *  will queue up to N blocks where N is the max "out of order"ness of the source.
 * 
 *  For example, if the source is 1,6,2,5,4,3 it will queue 3 blocks because 3 is 3
 *  blocks beyond where it belongs.
 * 
 *  This generator is not async-reentrant but it consists only of a simple log(n)
 *  insertion into a priority queue. */

/** @see MakeTransformedGenerator */

/** \brief Transform an async generator using a transformer function returning a new
 *  AsyncGenerator
 * 
 *  The transform function here behaves exactly the same as the transform function in
 *  MakeTransformedIterator and you can safely use the same transform function to
 *  transform both synchronous and asynchronous streams.
 * 
 *  This generator is not async-reentrant
 * 
 *  This generator may queue up to 1 instance of T but will not delay */

/** @see MakeSerialReadaheadGenerator */

/** @see MakeFromFuture */

/** \brief Transform a Future<AsyncGenerator<T>> into an AsyncGenerator<T>
 *  that waits for the future to complete as part of the first item.
 * 
 *  This generator is not async-reentrant (even if the generator yielded by future is)
 * 
 *  This generator does not queue */

/** \brief Create a generator that will pull from the source into a queue.  Unlike
 *  MakeReadaheadGenerator this will not pull reentrantly from the source.
 * 
 *  The source generator does not need to be async-reentrant
 * 
 *  This generator is not async-reentrant (even if the source is)
 * 
 *  This generator may queue up to max_readahead additional instances of T */

/** \brief Create a generator that immediately pulls from the source
 * 
 *  Typical generators do not pull from their source until they themselves
 *  are pulled.  This generator does not follow that convention and will call
 *  generator() once before it returns.  The returned generator will otherwise
 *  mirror the source.
 * 
 *  This generator forwards aysnc-reentrant pressure to the source
 *  This generator buffers one item (the first result) until it is delivered. */

/** @see MakeReadaheadGenerator */

/** \brief A generator where the producer pushes items on a queue.
 * 
 *  No back-pressure is applied, so this generator is mostly useful when
 *  producing the values is neither CPU- nor memory-expensive (e.g. fetching
 *  filesystem metadata).
 * 
 *  This generator is not async-reentrant. */

/** \brief Create a generator that pulls reentrantly from a source
 *  This generator will pull reentrantly from a source, ensuring that max_readahead
 *  requests are active at any given time.
 * 
 *  The source generator must be async-reentrant
 * 
 *  This generator itself is async-reentrant.
 * 
 *  This generator may queue up to max_readahead instances of T */

/** \brief Creates a generator that will yield finished futures from a vector
 * 
 *  This generator is async-reentrant */

/** @see MakeMergedGenerator */

/** \brief Create a generator that takes in a stream of generators and pulls from up to
 *  max_subscriptions at a time
 * 
 *  Note: This may deliver items out of sequence. For example, items from the third
 *  AsyncGenerator generated by the source may be emitted before some items from the first
 *  AsyncGenerator generated by the source.
 * 
 *  This generator will pull from source async-reentrantly unless max_subscriptions is 1
 *  This generator will not pull from the individual subscriptions reentrantly.  Add
 *  readahead to the individual subscriptions if that is desired.
 *  This generator is async-reentrant
 * 
 *  This generator may queue up to max_subscriptions instances of T */
// Targeting ..\..\arrow_dataset\FragmentEnumerated.java



/** @see MakeEnumeratedGenerator */

/** Wrap items from a source generator with positional information
 * 
 *  When used with MakeMergedGenerator and MakeSequencingGenerator this allows items to be
 *  processed in a "first-available" fashion and later resequenced which can reduce the
 *  impact of sources with erratic performance (e.g. a filesystem where some items may
 *  take longer to read than others).
 * 
 *  TODO(ARROW-12371) Would require this generator be async-reentrant
 * 
 *  @see MakeSequencingGenerator for an example of putting items back in order
 * 
 *  This generator is not async-reentrant
 * 
 *  This generator buffers one item (so it knows which item is the last item) */

/** @see MakeTransferredGenerator */

/** \brief Transfer a future to an underlying executor.
 * 
 *  Continuations run on the returned future will be run on the given executor
 *  if they cannot be run synchronously.
 * 
 *  This is often needed to move computation off I/O threads or other external
 *  completion sources and back on to the CPU executor so the I/O thread can
 *  stay busy and focused on I/O
 * 
 *  Keep in mind that continuations called on an already completed future will
 *  always be run synchronously and so no transfer will happen in that case.
 * 
 *  This generator is async reentrant if the source is
 * 
 *  This generator will not queue */

/** @see MakeBackgroundGenerator */

@Namespace("arrow") @MemberGetter public static native int kDefaultBackgroundMaxQ();

///
///
///
///
///
@Namespace("arrow") @MemberGetter public static native int kDefaultBackgroundQRestart();

/** \brief Create an AsyncGenerator<T> by iterating over an Iterator<T> on a background
 *  thread
 * 
 *  The parameter max_q and q_restart control queue size and background thread task
 *  management. If the background task is fast you typically don't want it creating a
 *  thread task for every item.  Instead the background thread will run until it fills
 *  up a readahead queue.
 * 
 *  Once the queue has filled up the background thread task will terminate (allowing other
 *  I/O tasks to use the thread).  Once the queue has been drained enough (specified by
 *  q_restart) then the background thread task will be restarted.  If q_restart is too low
 *  then you may exhaust the queue waiting for the background thread task to start running
 *  again.  If it is too high then it will be constantly stopping and restarting the
 *  background queue task
 * 
 *  The "background thread" is a logical thread and will run as tasks on the io_executor.
 *  This thread may stop and start when the queue fills up but there will only be one
 *  active background thread task at any given time.  You MUST transfer away from this
 *  background generator.  Otherwise there could be a race condition if a callback on the
 *  background thread deletes the last consumer reference to the background generator. You
 *  can transfer onto the same executor as the background thread, it is only neccesary to
 *  create a new thread task, not to switch executors.
 * 
 *  This generator is not async-reentrant
 * 
 *  This generator will queue up to max_q blocks */

/** @see MakeGeneratorIterator */

/** \brief Convert an AsyncGenerator<T> to an Iterator<T> which blocks until each future
 *  is finished */

/** \brief Add readahead to an iterator using a background thread.
 * 
 *  Under the hood this is converting the iterator to a generator using
 *  MakeBackgroundGenerator, adding readahead to the converted generator with
 *  MakeReadaheadGenerator, and then converting back to an iterator using
 *  MakeGeneratorIterator. */

/** \brief Make a generator that returns a single pre-generated future
 * 
 *  This generator is async-reentrant. */

/** \brief Make a generator that immediately ends.
 * 
 *  This generator is async-reentrant. */

/** \brief Make a generator that always fails with a given error
 * 
 *  This generator is async-reentrant. */

/** \brief Make a generator that always fails with a given error
 * 
 *  This overload allows inferring the return type from the argument. */

/** \brief Prepend initial_values onto a generator
 * 
 *  This generator is async-reentrant but will buffer requests and will not
 *  pull from following_values async-reentrantly. */

/** \brief Allow an async generator to be cancelled
 * 
 *  This generator is async-reentrant */

/** \brief Allow an async generator to be paused
 * 
 *  This generator is NOT async-reentrant and calling it in an async-reentrant fashion
 *  may lead to items getting reordered (and potentially truncated if the end token is
 *  reordered ahead of valid items)
 * 
 *  This generator forwards async-reentrant pressure */

/** \brief If the generator is empty, return the given value, else
 *  forward the values from the generator.
 * 
 *  This generator is async-reentrant. */
  // namespace arrow


// Parsed from arrow/result.h

//
// Copyright 2017 Asylo authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Adapted from Asylo

// #pragma once

// #include <cstddef>
// #include <new>
// #include <string>
// #include <type_traits>
// #include <utility>

// #include "arrow/status.h"
// #include "arrow/util/aligned_storage.h"
// #include "arrow/util/compare.h"
// Targeting ..\..\arrow_dataset\EnsureResult.java



@Namespace("arrow::internal") public static native void DieWithMessage(@StdString String msg);
@Namespace("arrow::internal") public static native void DieWithMessage(@StdString BytePointer msg);

@Namespace("arrow::internal") public static native void InvalidValueOrDie(@Const @ByRef Status st);


// Targeting ..\..\arrow_dataset\KeyOptionalResult.java


// Targeting ..\..\arrow_dataset\DatasetResult.java


// Targeting ..\..\arrow_dataset\DatasetFactoryResult.java


// Targeting ..\..\arrow_dataset\FileSystemDatasetResult.java


// Targeting ..\..\arrow_dataset\FileFragmentResult.java


// Targeting ..\..\arrow_dataset\FileWriterResult.java


// Targeting ..\..\arrow_dataset\FragmentResult.java


// Targeting ..\..\arrow_dataset\ParquetFileFragmentResult.java


// Targeting ..\..\arrow_dataset\PartitioningResult.java


// Targeting ..\..\arrow_dataset\ScannerResult.java


// Targeting ..\..\arrow_dataset\ScannerBuilderResult.java


// Targeting ..\..\arrow_dataset\ScanTaskResult.java


// Targeting ..\..\arrow_dataset\FileReaderResult.java


// Targeting ..\..\arrow_dataset\RecordBatchGeneratorResult.java


// Targeting ..\..\arrow_dataset\TaggedRecordBatchGeneratorResult.java


// Targeting ..\..\arrow_dataset\EnumeratedRecordBatchGeneratorResult.java


// Targeting ..\..\arrow_dataset\TaggedRecordBatchResult.java


// Targeting ..\..\arrow_dataset\TaggedRecordBatchVectorResult.java


// Targeting ..\..\arrow_dataset\EnumeratedRecordBatchResult.java


// Targeting ..\..\arrow_dataset\TaggedRecordBatchIteratorResult.java


// Targeting ..\..\arrow_dataset\EnumeratedRecordBatchIteratorResult.java


// Targeting ..\..\arrow_dataset\PartitionedBatchesResult.java


// Targeting ..\..\arrow_dataset\UnionDatasetResult.java


// Targeting ..\..\arrow_dataset\FragmentIteratorResult.java


// Targeting ..\..\arrow_dataset\ScanTaskIteratorResult.java


// Targeting ..\..\arrow_dataset\ScanTaskVectorResult.java


// Targeting ..\..\arrow_dataset\FragmentVectorResult.java



// #define ARROW_ASSIGN_OR_RAISE_IMPL(result_name, lhs, rexpr)
//   auto&& result_name = (rexpr);
//   ARROW_RETURN_IF_(!(result_name).ok(), (result_name).status(), ARROW_STRINGIFY(rexpr));
//   lhs = std::move(result_name).ValueUnsafe();


///
///
///
///
///
// #define ARROW_ASSIGN_OR_RAISE_NAME(x, y) ARROW_CONCAT(x, y)

/** \brief Execute an expression that returns a Result, extracting its value
 *  into the variable defined by {@code lhs} (or returning a Status on error).
 * 
 *  Example: Assigning to a new value:
 *    ARROW_ASSIGN_OR_RAISE(auto value, MaybeGetValue(arg));
 * 
 *  Example: Assigning to an existing value:
 *    ValueType value;
 *    ARROW_ASSIGN_OR_RAISE(value, MaybeGetValue(arg));
 * 
 *  WARNING: ARROW_ASSIGN_OR_RAISE expands into multiple statements;
 *  it cannot be used in a single statement (e.g. as the body of an if
 *  statement without {})!
 * 
 *  WARNING: ARROW_ASSIGN_OR_RAISE {@code std::move}s its right operand. If you have
 *  an lvalue Result which you *don't* want to move out of cast appropriately.
 * 
 *  WARNING: ARROW_ASSIGN_OR_RAISE is not a single expression; it will not
 *  maintain lifetimes of all temporaries in {@code rexpr} (e.g.
 *  {@code ARROW_ASSIGN_OR_RAISE(auto x, MakeTemp().GetResultRef());}
 *  will most likely segfault)! */
// #define ARROW_ASSIGN_OR_RAISE(lhs, rexpr)
//   ARROW_ASSIGN_OR_RAISE_IMPL(ARROW_ASSIGN_OR_RAISE_NAME(_error_or_value, __COUNTER__),
//                              lhs, rexpr);

  // namespace internal

  // namespace arrow


// Parsed from arrow/dataset/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include "arrow/compute/exec/expression.h"
// #include "arrow/dataset/dataset.h"
// #include "arrow/dataset/discovery.h"
// #include "arrow/dataset/file_base.h"
// #include "arrow/dataset/file_csv.h"
// #include "arrow/dataset/file_ipc.h"
// #include "arrow/dataset/file_orc.h"
// #include "arrow/dataset/file_parquet.h"
// #include "arrow/dataset/scanner.h"


// Parsed from arrow/dataset/visibility.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #if defined(_WIN32) || defined(__CYGWIN__)
// #if defined(_MSC_VER)
// #pragma warning(push)
// #pragma warning(disable : 4251)
// #else
// #pragma GCC diagnostic ignored "-Wattributes"
// #endif

// #ifdef ARROW_DS_STATIC
// #define ARROW_DS_EXPORT
// #elif defined(ARROW_DS_EXPORTING)
// #define ARROW_DS_EXPORT __declspec(dllexport)
// #else
// #define ARROW_DS_EXPORT __declspec(dllimport)
// #endif

// #define ARROW_DS_NO_EXPORT
// #else  // Not Windows
// #ifndef ARROW_DS_EXPORT
// #define ARROW_DS_EXPORT __attribute__((visibility("default")))
// #endif
// #ifndef ARROW_DS_NO_EXPORT
// #define ARROW_DS_NO_EXPORT __attribute__((visibility("hidden")))
// #endif
// #endif  // Non-Windows

// #if defined(_MSC_VER)
// #pragma warning(pop)
// #endif


// Parsed from arrow/dataset/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include <memory>
// #include <vector>

// #include "arrow/compute/type_fwd.h"  // IWYU pragma: export
// #include "arrow/dataset/visibility.h"
// #include "arrow/filesystem/type_fwd.h"  // IWYU pragma: export
// #include "arrow/type_fwd.h"             // IWYU pragma: export

/** \brief Controls what happens if files exist in an output directory during a dataset
 *  write */
@Namespace("arrow::dataset") public enum ExistingDataBehavior {
  /** Deletes all files in a directory the first time that directory is encountered */
  kDeleteMatchingPartitions((byte)(0)),
  /** Ignores existing files, overwriting any that happen to have the same name as an
   *  output file */
  kOverwriteOrIgnore((byte)(1)),
  /** Returns an error if there are any files or subdirectories in the output directory */
  kError((byte)(2));

    public final byte value;
    private ExistingDataBehavior(byte v) { this.value = v; }
    private ExistingDataBehavior(ExistingDataBehavior e) { this.value = e.value; }
    public ExistingDataBehavior intern() { for (ExistingDataBehavior e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/dataset.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include <functional>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/compute/exec/expression.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/mutex.h"
// #include "arrow/util/optional.h"


///
///
// Targeting ..\..\arrow_dataset\Fragment.java


// Targeting ..\..\arrow_dataset\FragmentScanOptions.java


// Targeting ..\..\arrow_dataset\InMemoryFragment.java


// Targeting ..\..\arrow_dataset\Dataset.java


// Targeting ..\..\arrow_dataset\InMemoryDataset.java


// Targeting ..\..\arrow_dataset\UnionDataset.java



/** \} */

  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/partition.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include <functional>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <unordered_map>
// #include <utility>
// #include <vector>

// #include "arrow/compute/exec/expression.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/util/optional.h"
// Targeting ..\..\arrow_dataset\Partitioning.java



/** \brief The encoding of partition segments. */
@Namespace("arrow::dataset") public enum SegmentEncoding {
  /** No encoding. */
  None((byte)(0)),
  /** Segment values are URL-encoded. */
  Uri((byte)(1));

    public final byte value;
    private SegmentEncoding(byte v) { this.value = v; }
    private SegmentEncoding(SegmentEncoding e) { this.value = e.value; }
    public SegmentEncoding intern() { for (SegmentEncoding e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

@Namespace("arrow::dataset") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, SegmentEncoding segment_encoding);
@Namespace("arrow::dataset") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Cast("arrow::dataset::SegmentEncoding") byte segment_encoding);
// Targeting ..\..\arrow_dataset\KeyValuePartitioningOptions.java


// Targeting ..\..\arrow_dataset\PartitioningFactoryOptions.java


// Targeting ..\..\arrow_dataset\HivePartitioningFactoryOptions.java


// Targeting ..\..\arrow_dataset\PartitioningFactory.java


// Targeting ..\..\arrow_dataset\KeyValuePartitioning.java


// Targeting ..\..\arrow_dataset\DirectoryPartitioning.java



/** \brief The default fallback used for null values in a Hive-style partitioning. */
@Namespace("arrow::dataset") @MemberGetter public static native byte kDefaultHiveNullFallback(int i);
@Namespace("arrow::dataset") @MemberGetter public static native String kDefaultHiveNullFallback();
// Targeting ..\..\arrow_dataset\HivePartitioningOptions.java


// Targeting ..\..\arrow_dataset\HivePartitioning.java


// Targeting ..\..\arrow_dataset\FunctionPartitioning.java



/** \brief Remove a prefix and the filename of a path.
 * 
 *  e.g., {@code StripPrefixAndFilename("/data/year=2019/c.txt", "/data") -> "year=2019"} */
@Namespace("arrow::dataset") public static native @StdString String StripPrefixAndFilename(@StdString String path,
                                                   @StdString String prefix);
@Namespace("arrow::dataset") public static native @StdString BytePointer StripPrefixAndFilename(@StdString BytePointer path,
                                                   @StdString BytePointer prefix);

/** \brief Vector version of StripPrefixAndFilename. */
@Namespace("arrow::dataset") public static native @ByVal StringVector StripPrefixAndFilename(
    @Const @ByRef StringVector paths, @StdString String prefix);
@Namespace("arrow::dataset") public static native @ByVal StringVector StripPrefixAndFilename(
    @Const @ByRef StringVector paths, @StdString BytePointer prefix);

/** \brief Vector version of StripPrefixAndFilename. */
@Namespace("arrow::dataset") public static native @ByVal StringVector StripPrefixAndFilename(
    @Const @ByRef FileInfoVector files, @StdString String prefix);
@Namespace("arrow::dataset") public static native @ByVal StringVector StripPrefixAndFilename(
    @Const @ByRef FileInfoVector files, @StdString BytePointer prefix);
// Targeting ..\..\arrow_dataset\PartitioningOrFactory.java



/** \} */

  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/discovery.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

/** Logic for automatically determining the structure of multi-file
 *  dataset with possible partitioning according to available
 *  partitioning */

// This API is EXPERIMENTAL.

// #pragma once

// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/dataset/partition.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/filesystem/type_fwd.h"
// #include "arrow/result.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/variant.h"
// Targeting ..\..\arrow_dataset\InspectOptions.java


// Targeting ..\..\arrow_dataset\FinishOptions.java


// Targeting ..\..\arrow_dataset\DatasetFactory.java


// Targeting ..\..\arrow_dataset\UnionDatasetFactory.java


// Targeting ..\..\arrow_dataset\FileSystemFactoryOptions.java


// Targeting ..\..\arrow_dataset\FileSystemDatasetFactory.java



  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/projector.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include "arrow/dataset/visibility.h"
// #include "arrow/type_fwd.h"

// FIXME this is superceded by compute::Expression::Bind
@Namespace("arrow::dataset") public static native @ByVal Status CheckProjectable(@Const @ByRef Schema from, @Const @ByRef Schema to);

  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/scanner.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include <functional>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/compute/exec/expression.h"
// #include "arrow/compute/exec/options.h"
// #include "arrow/compute/type_fwd.h"
// #include "arrow/dataset/dataset.h"
// #include "arrow/dataset/projector.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/memory_pool.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/async_generator.h"
// #include "arrow/util/iterator.h"
// #include "arrow/util/thread_pool.h"
// #include "arrow/util/type_fwd.h"

/** \defgroup dataset-scanning Scanning API
 * 
 *  \{ */

@Namespace("arrow::dataset") @MemberGetter public static native @Cast("const int64_t") long kDefaultBatchSize();
@Namespace("arrow::dataset") @MemberGetter public static native int kDefaultBatchReadahead();
@Namespace("arrow::dataset") @MemberGetter public static native int kDefaultFragmentReadahead();
@Namespace("arrow::dataset") @MemberGetter public static native int kDefaultBackpressureHigh();
@Namespace("arrow::dataset") @MemberGetter public static native int kDefaultBackpressureLow();
// Targeting ..\..\arrow_dataset\ScanOptions.java


// Targeting ..\..\arrow_dataset\ScanTask.java


// Targeting ..\..\arrow_dataset\TaggedRecordBatch.java



///
// Targeting ..\..\arrow_dataset\EnumeratedRecordBatch.java



/** \} */


// Targeting ..\..\arrow_dataset\IterationTraits.java


// Targeting ..\..\arrow_dataset\Scanner.java


// Targeting ..\..\arrow_dataset\ScannerBuilder.java


// Targeting ..\..\arrow_dataset\ScanNodeOptions.java


// Targeting ..\..\arrow_dataset\InMemoryScanTask.java


@Namespace("arrow::dataset::internal") public static native void InitializeScanner(ExecFactoryRegistry registry);
  // namespace internal
  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/file_base.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include <functional>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/buffer.h"
// #include "arrow/dataset/dataset.h"
// #include "arrow/dataset/partition.h"
// #include "arrow/dataset/scanner.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/filesystem/filesystem.h"
// #include "arrow/io/file.h"
// #include "arrow/util/compression.h"
// Targeting ..\..\arrow_dataset\FileSource.java


// Targeting ..\..\arrow_dataset\FileFormat.java


// Targeting ..\..\arrow_dataset\FileFragment.java


// Targeting ..\..\arrow_dataset\FileSystemDataset.java


// Targeting ..\..\arrow_dataset\FileWriteOptions.java


// Targeting ..\..\arrow_dataset\FileWriter.java


// Targeting ..\..\arrow_dataset\FileSystemDatasetWriteOptions.java


// Targeting ..\..\arrow_dataset\WriteNodeOptions.java



/** \} */
@Namespace("arrow::dataset::internal") public static native void InitializeDatasetWriter(
    ExecFactoryRegistry registry);


  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/file_csv.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>

// #include "arrow/csv/options.h"
// #include "arrow/dataset/dataset.h"
// #include "arrow/dataset/file_base.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/ipc/type_fwd.h"
// #include "arrow/status.h"
// #include "arrow/util/compression.h"


///
@Namespace("arrow::dataset") @MemberGetter public static native byte kCsvTypeName(int i);
@Namespace("arrow::dataset") @MemberGetter public static native String kCsvTypeName();
// Targeting ..\..\arrow_dataset\CsvFileFormat.java


// Targeting ..\..\arrow_dataset\CsvFragmentScanOptions.java


// Targeting ..\..\arrow_dataset\CsvFileWriteOptions.java


// Targeting ..\..\arrow_dataset\CsvFileWriter.java



/** \} */

  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/file_ipc.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include <memory>
// #include <string>

// #include "arrow/dataset/file_base.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/io/type_fwd.h"
// #include "arrow/ipc/type_fwd.h"
// #include "arrow/result.h"

/** \addtogroup dataset-file-formats
 * 
 *  \{ */

@Namespace("arrow::dataset") @MemberGetter public static native byte kIpcTypeName(int i);
@Namespace("arrow::dataset") @MemberGetter public static native String kIpcTypeName();
// Targeting ..\..\arrow_dataset\IpcFileFormat.java


// Targeting ..\..\arrow_dataset\IpcFragmentScanOptions.java


// Targeting ..\..\arrow_dataset\IpcFileWriteOptions.java


// Targeting ..\..\arrow_dataset\IpcFileWriter.java



/** \} */

  // namespace dataset
  // namespace arrow


// Parsed from arrow/dataset/file_parquet.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// This API is EXPERIMENTAL.

// #pragma once

// #include <memory>
// #include <string>
// #include <unordered_set>
// #include <utility>
// #include <vector>

// #include "arrow/dataset/discovery.h"
// #include "arrow/dataset/file_base.h"
// #include "arrow/dataset/type_fwd.h"
// #include "arrow/dataset/visibility.h"
// #include "arrow/io/caching.h"
// #include "arrow/util/optional.h"
// Targeting ..\..\arrow_dataset\SchemaManifest.java


  // namespace arrow
  // namespace parquet

/** \addtogroup dataset-file-formats
 * 
 *  \{ */

@Namespace("arrow::dataset") @MemberGetter public static native byte kParquetTypeName(int i);
@Namespace("arrow::dataset") @MemberGetter public static native String kParquetTypeName();
// Targeting ..\..\arrow_dataset\ParquetFileFormat.java


// Targeting ..\..\arrow_dataset\ParquetFileFragment.java


// Targeting ..\..\arrow_dataset\ParquetFragmentScanOptions.java


// Targeting ..\..\arrow_dataset\ParquetFileWriteOptions.java


// Targeting ..\..\arrow_dataset\ParquetFileWriter.java


// Targeting ..\..\arrow_dataset\ParquetFactoryOptions.java


// Targeting ..\..\arrow_dataset\ParquetDatasetFactory.java



/** \} */

  // namespace dataset
  // namespace arrow


}
