// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief DatasetFactory provides a way to inspect/discover a Dataset's expected
 *  schema before materializing said Dataset. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class DatasetFactory extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DatasetFactory(Pointer p) { super(p); }

  /** \brief Get the schemas of the Fragments and Partitioning. */
  public native @ByVal SchemaVectorResult InspectSchemas(
        @ByVal InspectOptions options);

  /** \brief Get unified schema for the resulting Dataset. */
  public native @ByVal SchemaResult Inspect(@ByVal(nullValue = "arrow::dataset::InspectOptions{}") InspectOptions options);
  public native @ByVal SchemaResult Inspect();

  /** \brief Create a Dataset */
  public native @ByVal DatasetResult Finish();
  /** \brief Create a Dataset with the given schema (see \a InspectOptions::schema) */
  public native @ByVal DatasetResult Finish(@SharedPtr @ByVal Schema schema);
  /** \brief Create a Dataset with the given options */
  public native @ByVal DatasetResult Finish(@ByVal FinishOptions options);

  /** \brief Optional root partition for the resulting Dataset. */
  public native @Const @ByRef Expression root_partition();
  /** \brief Set the root partition for the resulting Dataset. */
  public native @ByVal Status SetRootPartition(@ByVal Expression partition);
}
