// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Construct a source ExecNode which yields batches from a dataset scan.
 * 
 *  Does not construct associated filter or project nodes.
 *  Yielded batches will be augmented with fragment/batch indices to enable stable
 *  ordering for simple ExecPlans. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class ScanNodeOptions extends ExecNodeOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ScanNodeOptions(Pointer p) { super(p); }

  public ScanNodeOptions(
        @SharedPtr @ByVal Dataset dataset, @SharedPtr ScanOptions scan_options,
        @SharedPtr AsyncToggle backpressure_toggle/*=nullptr*/,
        @Cast("bool") boolean require_sequenced_output/*=false*/) { super((Pointer)null); allocate(dataset, scan_options, backpressure_toggle, require_sequenced_output); }
  private native void allocate(
        @SharedPtr @ByVal Dataset dataset, @SharedPtr ScanOptions scan_options,
        @SharedPtr AsyncToggle backpressure_toggle/*=nullptr*/,
        @Cast("bool") boolean require_sequenced_output/*=false*/);
  public ScanNodeOptions(
        @SharedPtr @ByVal Dataset dataset, @SharedPtr ScanOptions scan_options) { super((Pointer)null); allocate(dataset, scan_options); }
  private native void allocate(
        @SharedPtr @ByVal Dataset dataset, @SharedPtr ScanOptions scan_options);

  public native @SharedPtr @ByRef Dataset dataset(); public native ScanNodeOptions dataset(Dataset setter);
  public native @SharedPtr ScanOptions scan_options(); public native ScanNodeOptions scan_options(ScanOptions setter);
  public native @SharedPtr AsyncToggle backpressure_toggle(); public native ScanNodeOptions backpressure_toggle(AsyncToggle setter);
  public native @Cast("bool") boolean require_sequenced_output(); public native ScanNodeOptions require_sequenced_output(boolean setter);
}
