// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \defgroup dataset-scanning Scanning API
 * 
 *  \{
 <p>
 *  \brief A scanner glues together several dataset classes to load in data.
 *  The dataset contains a collection of fragments and partitioning rules.
 * 
 *  The fragments identify independently loadable units of data (i.e. each fragment has
 *  a potentially unique schema and possibly even format.  It should be possible to read
 *  fragments in parallel if desired).
 * 
 *  The fragment's format contains the logic necessary to actually create a task to load
 *  the fragment into memory.  That task may or may not support parallel execution of
 *  its own.
 * 
 *  The scanner is then responsible for creating scan tasks from every fragment in the
 *  dataset and (potentially) sequencing the loaded record batches together.
 * 
 *  The scanner should not buffer the entire dataset in memory (unless asked) instead
 *  yielding record batches as soon as they are ready to scan.  Various readahead
 *  properties control how much data is allowed to be scanned before pausing to let a
 *  slow consumer catchup.
 * 
 *  Today the scanner also handles projection & filtering although that may change in
 *  the future. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class Scanner extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Scanner(Pointer p) { super(p); }


  /** \brief The Scan operator returns a stream of ScanTask. The caller is
   *  responsible to dispatch/schedule said tasks. Tasks should be safe to run
   *  in a concurrent fashion and outlive the iterator.
   * 
   *  Note: Not supported by the async scanner
   *  Planned for removal from the public API in ARROW-11782. */
  public native @Deprecated @ByVal ScanTaskIteratorResult Scan();

  /** \brief Apply a visitor to each RecordBatch as it is scanned. If multiple threads
   *  are used (via use_threads), the visitor will be invoked from those threads and is
   *  responsible for any synchronization. */
  
  ///
  public native @ByVal Status Scan(@ByVal TaggedRecordBatchVisitor visitor);
  /** \brief Convert a Scanner into a Table.
   * 
   *  Use this convenience utility with care. This will serially materialize the
   *  Scan result in memory before creating the Table. */
  
  ///
  public native @ByVal TableResult ToTable();
  /** \brief Scan the dataset into a stream of record batches.  Each batch is tagged
   *  with the fragment it originated from.  The batches will arrive in order.  The
   *  order of fragments is determined by the dataset.
   * 
   *  Note: The scanner will perform some readahead but will avoid materializing too
   *  much in memory (this is goverended by the readahead options and use_threads option).
   *  If the readahead queue fills up then I/O will pause until the calling thread catches
   *  up. */
  public native @ByVal TaggedRecordBatchIteratorResult ScanBatches();
  
  ///
  public native @ByVal TaggedRecordBatchGeneratorResult ScanBatchesAsync();
  /** \brief Scan the dataset into a stream of record batches.  Unlike ScanBatches this
   *  method may allow record batches to be returned out of order.  This allows for more
   *  efficient scanning: some fragments may be accessed more quickly than others (e.g.
   *  may be cached in RAM or just happen to get scheduled earlier by the I/O)
   * 
   *  To make up for the out-of-order iteration each batch is further tagged with
   *  positional information. */
  public native @ByVal EnumeratedRecordBatchIteratorResult ScanBatchesUnordered();
  
  ///
  public native @ByVal EnumeratedRecordBatchGeneratorResult ScanBatchesUnorderedAsync();
  /** \brief A convenience to synchronously load the given rows by index.
   * 
   *  Will only consume as many batches as needed from ScanBatches(). */
  public native @ByVal TableResult TakeRows(@Const @ByRef Array indices);
  /** \brief Get the first N rows. */
  
  ///
  public native @ByVal TableResult Head(@Cast("int64_t") long num_rows);
  /** \brief Count rows matching a predicate.
   * 
   *  This method will push down the predicate and compute the result based on fragment
   *  metadata if possible. */
  public native @ByVal LongResult CountRows();
  /** \brief Convert the Scanner to a RecordBatchReader so it can be
   *  easily used with APIs that expect a reader. */
  public native @ByVal RecordBatchReaderSharedResult ToRecordBatchReader();

  /** \brief Get the options for this scan. */
  public native @SharedPtr ScanOptions options();
  /** \brief Get the dataset that this scanner will scan */
  public native @Const @SharedPtr @ByRef Dataset dataset();
}
