// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


// ----------------------------------------------------------------------
// Metadata enums to match Thrift metadata
//
// The reason we maintain our own enums is to avoid transitive dependency on
// the compiled Thrift headers (and thus thrift/Thrift.h) for users of the
// public API. After building parquet-cpp, you should not need to include
// Thrift headers in your application. This means some boilerplate to convert
// between our types and Parquet's Thrift types.
//
// We can also add special values like NONE to distinguish between metadata
// values being set and not set. As an example consider ConvertedType and
// CompressionCodec

// Mirrors parquet::Type
@Name("parquet::Type") @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class Type extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public Type() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Type(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Type(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public Type position(long position) {
        return (Type)super.position(position);
    }
    @Override public Type getPointer(long i) {
        return new Type((Pointer)this).offsetAddress(i);
    }

  public enum type {
    BOOLEAN(0),
    INT32(1),
    INT64(2),
    INT96(3),
    FLOAT(4),
    DOUBLE(5),
    BYTE_ARRAY(6),
    FIXED_LEN_BYTE_ARRAY(7),
    // Should always be last element.
    UNDEFINED(8);

      public final int value;
      private type(int v) { this.value = v; }
      private type(type e) { this.value = e.value; }
      public type intern() { for (type e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }
}
