// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3OpenCL;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.Bullet3Common.*;
import static org.bytedeco.bullet.global.Bullet3Common.*;
import org.bytedeco.bullet.Bullet3Collision.*;
import static org.bytedeco.bullet.global.Bullet3Collision.*;
import org.bytedeco.bullet.Bullet3Dynamics.*;
import static org.bytedeco.bullet.global.Bullet3Dynamics.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.Bullet3OpenCL.*;


/**The b3TriangleIndexVertexArray allows to access multiple triangle meshes, by indexing into existing triangle/index arrays.
 * Additional meshes can be added using addIndexedMesh
 * No duplcate is made of the vertex/index data, it only indexes into external vertex/index arrays.
 * So keep those arrays around during the lifetime of this b3TriangleIndexVertexArray. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.Bullet3OpenCL.class)
public class b3TriangleIndexVertexArray extends b3StridingMeshInterface {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3TriangleIndexVertexArray(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b3TriangleIndexVertexArray(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b3TriangleIndexVertexArray position(long position) {
        return (b3TriangleIndexVertexArray)super.position(position);
    }
    @Override public b3TriangleIndexVertexArray getPointer(long i) {
        return new b3TriangleIndexVertexArray((Pointer)this).offsetAddress(i);
    }


	public b3TriangleIndexVertexArray() { super((Pointer)null); allocate(); }
	private native void allocate();

	//just to be backwards compatible
	public b3TriangleIndexVertexArray(int numTriangles, IntPointer triangleIndexBase, int triangleIndexStride, int numVertices, @Cast("b3Scalar*") FloatPointer vertexBase, int vertexStride) { super((Pointer)null); allocate(numTriangles, triangleIndexBase, triangleIndexStride, numVertices, vertexBase, vertexStride); }
	private native void allocate(int numTriangles, IntPointer triangleIndexBase, int triangleIndexStride, int numVertices, @Cast("b3Scalar*") FloatPointer vertexBase, int vertexStride);
	public b3TriangleIndexVertexArray(int numTriangles, IntBuffer triangleIndexBase, int triangleIndexStride, int numVertices, @Cast("b3Scalar*") FloatBuffer vertexBase, int vertexStride) { super((Pointer)null); allocate(numTriangles, triangleIndexBase, triangleIndexStride, numVertices, vertexBase, vertexStride); }
	private native void allocate(int numTriangles, IntBuffer triangleIndexBase, int triangleIndexStride, int numVertices, @Cast("b3Scalar*") FloatBuffer vertexBase, int vertexStride);
	public b3TriangleIndexVertexArray(int numTriangles, int[] triangleIndexBase, int triangleIndexStride, int numVertices, @Cast("b3Scalar*") float[] vertexBase, int vertexStride) { super((Pointer)null); allocate(numTriangles, triangleIndexBase, triangleIndexStride, numVertices, vertexBase, vertexStride); }
	private native void allocate(int numTriangles, int[] triangleIndexBase, int triangleIndexStride, int numVertices, @Cast("b3Scalar*") float[] vertexBase, int vertexStride);

	public native void addIndexedMesh(@Const @ByRef b3IndexedMesh mesh, @Cast("PHY_ScalarType") int indexType/*=PHY_INTEGER*/);
	public native void addIndexedMesh(@Const @ByRef b3IndexedMesh mesh);

	public native void getLockedVertexIndexBase(@Cast("unsigned char**") PointerPointer vertexbase, @ByRef IntPointer numverts, @Cast("PHY_ScalarType*") @ByRef IntPointer type, @ByRef IntPointer vertexStride, @Cast("unsigned char**") PointerPointer indexbase, @ByRef IntPointer indexstride, @ByRef IntPointer numfaces, @Cast("PHY_ScalarType*") @ByRef IntPointer indicestype, int subpart/*=0*/);
	public native void getLockedVertexIndexBase(@Cast("unsigned char**") @ByPtrPtr BytePointer vertexbase, @ByRef IntPointer numverts, @Cast("PHY_ScalarType*") @ByRef IntPointer type, @ByRef IntPointer vertexStride, @Cast("unsigned char**") @ByPtrPtr BytePointer indexbase, @ByRef IntPointer indexstride, @ByRef IntPointer numfaces, @Cast("PHY_ScalarType*") @ByRef IntPointer indicestype);
	public native void getLockedVertexIndexBase(@Cast("unsigned char**") @ByPtrPtr BytePointer vertexbase, @ByRef IntPointer numverts, @Cast("PHY_ScalarType*") @ByRef IntPointer type, @ByRef IntPointer vertexStride, @Cast("unsigned char**") @ByPtrPtr BytePointer indexbase, @ByRef IntPointer indexstride, @ByRef IntPointer numfaces, @Cast("PHY_ScalarType*") @ByRef IntPointer indicestype, int subpart/*=0*/);
	public native void getLockedVertexIndexBase(@Cast("unsigned char**") @ByPtrPtr ByteBuffer vertexbase, @ByRef IntBuffer numverts, @Cast("PHY_ScalarType*") @ByRef IntBuffer type, @ByRef IntBuffer vertexStride, @Cast("unsigned char**") @ByPtrPtr ByteBuffer indexbase, @ByRef IntBuffer indexstride, @ByRef IntBuffer numfaces, @Cast("PHY_ScalarType*") @ByRef IntBuffer indicestype, int subpart/*=0*/);
	public native void getLockedVertexIndexBase(@Cast("unsigned char**") @ByPtrPtr ByteBuffer vertexbase, @ByRef IntBuffer numverts, @Cast("PHY_ScalarType*") @ByRef IntBuffer type, @ByRef IntBuffer vertexStride, @Cast("unsigned char**") @ByPtrPtr ByteBuffer indexbase, @ByRef IntBuffer indexstride, @ByRef IntBuffer numfaces, @Cast("PHY_ScalarType*") @ByRef IntBuffer indicestype);
	public native void getLockedVertexIndexBase(@Cast("unsigned char**") @ByPtrPtr byte[] vertexbase, @ByRef int[] numverts, @Cast("PHY_ScalarType*") @ByRef int[] type, @ByRef int[] vertexStride, @Cast("unsigned char**") @ByPtrPtr byte[] indexbase, @ByRef int[] indexstride, @ByRef int[] numfaces, @Cast("PHY_ScalarType*") @ByRef int[] indicestype, int subpart/*=0*/);
	public native void getLockedVertexIndexBase(@Cast("unsigned char**") @ByPtrPtr byte[] vertexbase, @ByRef int[] numverts, @Cast("PHY_ScalarType*") @ByRef int[] type, @ByRef int[] vertexStride, @Cast("unsigned char**") @ByPtrPtr byte[] indexbase, @ByRef int[] indexstride, @ByRef int[] numfaces, @Cast("PHY_ScalarType*") @ByRef int[] indicestype);

	public native void getLockedReadOnlyVertexIndexBase(@Cast("const unsigned char**") PointerPointer vertexbase, @ByRef IntPointer numverts, @Cast("PHY_ScalarType*") @ByRef IntPointer type, @ByRef IntPointer vertexStride, @Cast("const unsigned char**") PointerPointer indexbase, @ByRef IntPointer indexstride, @ByRef IntPointer numfaces, @Cast("PHY_ScalarType*") @ByRef IntPointer indicestype, int subpart/*=0*/);
	public native void getLockedReadOnlyVertexIndexBase(@Cast("const unsigned char**") @ByPtrPtr BytePointer vertexbase, @ByRef IntPointer numverts, @Cast("PHY_ScalarType*") @ByRef IntPointer type, @ByRef IntPointer vertexStride, @Cast("const unsigned char**") @ByPtrPtr BytePointer indexbase, @ByRef IntPointer indexstride, @ByRef IntPointer numfaces, @Cast("PHY_ScalarType*") @ByRef IntPointer indicestype);
	public native void getLockedReadOnlyVertexIndexBase(@Cast("const unsigned char**") @ByPtrPtr BytePointer vertexbase, @ByRef IntPointer numverts, @Cast("PHY_ScalarType*") @ByRef IntPointer type, @ByRef IntPointer vertexStride, @Cast("const unsigned char**") @ByPtrPtr BytePointer indexbase, @ByRef IntPointer indexstride, @ByRef IntPointer numfaces, @Cast("PHY_ScalarType*") @ByRef IntPointer indicestype, int subpart/*=0*/);
	public native void getLockedReadOnlyVertexIndexBase(@Cast("const unsigned char**") @ByPtrPtr ByteBuffer vertexbase, @ByRef IntBuffer numverts, @Cast("PHY_ScalarType*") @ByRef IntBuffer type, @ByRef IntBuffer vertexStride, @Cast("const unsigned char**") @ByPtrPtr ByteBuffer indexbase, @ByRef IntBuffer indexstride, @ByRef IntBuffer numfaces, @Cast("PHY_ScalarType*") @ByRef IntBuffer indicestype, int subpart/*=0*/);
	public native void getLockedReadOnlyVertexIndexBase(@Cast("const unsigned char**") @ByPtrPtr ByteBuffer vertexbase, @ByRef IntBuffer numverts, @Cast("PHY_ScalarType*") @ByRef IntBuffer type, @ByRef IntBuffer vertexStride, @Cast("const unsigned char**") @ByPtrPtr ByteBuffer indexbase, @ByRef IntBuffer indexstride, @ByRef IntBuffer numfaces, @Cast("PHY_ScalarType*") @ByRef IntBuffer indicestype);
	public native void getLockedReadOnlyVertexIndexBase(@Cast("const unsigned char**") @ByPtrPtr byte[] vertexbase, @ByRef int[] numverts, @Cast("PHY_ScalarType*") @ByRef int[] type, @ByRef int[] vertexStride, @Cast("const unsigned char**") @ByPtrPtr byte[] indexbase, @ByRef int[] indexstride, @ByRef int[] numfaces, @Cast("PHY_ScalarType*") @ByRef int[] indicestype, int subpart/*=0*/);
	public native void getLockedReadOnlyVertexIndexBase(@Cast("const unsigned char**") @ByPtrPtr byte[] vertexbase, @ByRef int[] numverts, @Cast("PHY_ScalarType*") @ByRef int[] type, @ByRef int[] vertexStride, @Cast("const unsigned char**") @ByPtrPtr byte[] indexbase, @ByRef int[] indexstride, @ByRef int[] numfaces, @Cast("PHY_ScalarType*") @ByRef int[] indicestype);

	/** unLockVertexBase finishes the access to a subpart of the triangle mesh
	 *  make a call to unLockVertexBase when the read and write access (using getLockedVertexIndexBase) is finished */
	public native void unLockVertexBase(int subpart);

	public native void unLockReadOnlyVertexBase(int subpart);

	/** getNumSubParts returns the number of separate subparts
	 *  each subpart has a continuous array of vertices and indices */
	public native int getNumSubParts();

	public native @Cast("IndexedMeshArray*") @ByRef b3ConvexUtilityArray getIndexedMeshArray();

	public native void preallocateVertices(int numverts);
	public native void preallocateIndices(int numindices);

	public native @Cast("bool") boolean hasPremadeAabb();
	public native void setPremadeAabb(@Const @ByRef b3Vector3 aabbMin, @Const @ByRef b3Vector3 aabbMax);
	public native void getPremadeAabb(b3Vector3 aabbMin, b3Vector3 aabbMax);
}
