// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletDynamics;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;

import static org.bytedeco.bullet.global.BulletDynamics.*;


/**The btDynamicsWorld is the interface class for several dynamics implementation, basic, discrete, parallel, and continuous etc. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletDynamics.class)
public class btDynamicsWorld extends btCollisionWorld {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btDynamicsWorld(Pointer p) { super(p); }


	/**stepSimulation proceeds the simulation over 'timeStep', units in preferably in seconds.
	 * By default, Bullet will subdivide the timestep in constant substeps of each 'fixedTimeStep'.
	 * in order to keep the simulation real-time, the maximum number of substeps can be clamped to 'maxSubSteps'.
	 * You can disable subdividing the timestep/substepping by passing maxSubSteps=0 as second argument to stepSimulation, but in that case you have to keep the timeStep constant. */
	public native int stepSimulation(@Cast("btScalar") double timeStep, int maxSubSteps/*=1*/, @Cast("btScalar") double fixedTimeStep/*=btScalar(1.) / btScalar(60.)*/);
	public native int stepSimulation(@Cast("btScalar") double timeStep);

	public native void debugDrawWorld();

	public native void addConstraint(btTypedConstraint constraint, @Cast("bool") boolean disableCollisionsBetweenLinkedBodies/*=false*/);
	public native void addConstraint(btTypedConstraint constraint);

	public native void removeConstraint(btTypedConstraint constraint);

	public native void addAction(btActionInterface action);

	public native void removeAction(btActionInterface action);

	//once a rigidbody is added to the dynamics world, it will get this gravity assigned
	//existing rigidbodies in the world get gravity assigned too, during this method
	public native void setGravity(@Const @ByRef btVector3 gravity);
	public native @ByVal btVector3 getGravity();

	public native void synchronizeMotionStates();

	public native void addRigidBody(btRigidBody body);

	public native void addRigidBody(btRigidBody body, int group, int mask);

	public native void removeRigidBody(btRigidBody body);

	public native void setConstraintSolver(btConstraintSolver solver);

	public native btConstraintSolver getConstraintSolver();

	public native int getNumConstraints();

	public native btTypedConstraint getConstraint(int index);

	public native @Cast("btDynamicsWorldType") int getWorldType();

	public native void clearForces();

	/** Set the callback for when an internal tick (simulation substep) happens, optional user info */
	public native void setInternalTickCallback(btInternalTickCallback cb, Pointer worldUserInfo/*=0*/, @Cast("bool") boolean isPreTick/*=false*/);
	public native void setInternalTickCallback(btInternalTickCallback cb);

	public native void setWorldUserInfo(Pointer worldUserInfo);

	public native Pointer getWorldUserInfo();

	public native @ByRef btContactSolverInfo getSolverInfo();

	/**obsolete, use addAction instead. */
	public native void addVehicle(btActionInterface vehicle);
	/**obsolete, use removeAction instead */
	public native void removeVehicle(btActionInterface vehicle);
	/**obsolete, use addAction instead. */
	public native void addCharacter(btActionInterface character);
	/**obsolete, use removeAction instead */
	public native void removeCharacter(btActionInterface character);
}
