// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletDynamics;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;

import static org.bytedeco.bullet.global.BulletDynamics.*;

// #endif

/**The btSolverBody is an internal datastructure for the constraint solver. Only necessary data is packed to increase cache coherence/performance. */
@Properties(inherit = org.bytedeco.bullet.presets.BulletDynamics.class)
public class btSolverBody extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public btSolverBody() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btSolverBody(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btSolverBody(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public btSolverBody position(long position) {
        return (btSolverBody)super.position(position);
    }
    @Override public btSolverBody getPointer(long i) {
        return new btSolverBody((Pointer)this).offsetAddress(i);
    }

	public native @ByRef btTransform m_worldTransform(); public native btSolverBody m_worldTransform(btTransform setter);
	public native @ByRef btVector3 m_deltaLinearVelocity(); public native btSolverBody m_deltaLinearVelocity(btVector3 setter);
	public native @ByRef btVector3 m_deltaAngularVelocity(); public native btSolverBody m_deltaAngularVelocity(btVector3 setter);
	public native @ByRef btVector3 m_angularFactor(); public native btSolverBody m_angularFactor(btVector3 setter);
	public native @ByRef btVector3 m_linearFactor(); public native btSolverBody m_linearFactor(btVector3 setter);
	public native @ByRef btVector3 m_invMass(); public native btSolverBody m_invMass(btVector3 setter);
	public native @ByRef btVector3 m_pushVelocity(); public native btSolverBody m_pushVelocity(btVector3 setter);
	public native @ByRef btVector3 m_turnVelocity(); public native btSolverBody m_turnVelocity(btVector3 setter);
	public native @ByRef btVector3 m_linearVelocity(); public native btSolverBody m_linearVelocity(btVector3 setter);
	public native @ByRef btVector3 m_angularVelocity(); public native btSolverBody m_angularVelocity(btVector3 setter);
	public native @ByRef btVector3 m_externalForceImpulse(); public native btSolverBody m_externalForceImpulse(btVector3 setter);
	public native @ByRef btVector3 m_externalTorqueImpulse(); public native btSolverBody m_externalTorqueImpulse(btVector3 setter);

	public native btRigidBody m_originalBody(); public native btSolverBody m_originalBody(btRigidBody setter);
	public native void setWorldTransform(@Const @ByRef btTransform worldTransform);

	public native @Const @ByRef btTransform getWorldTransform();

	public native void getVelocityInLocalPointNoDelta(@Const @ByRef btVector3 rel_pos, @ByRef btVector3 velocity);

	public native void getVelocityInLocalPointObsolete(@Const @ByRef btVector3 rel_pos, @ByRef btVector3 velocity);

	public native void getAngularVelocity(@ByRef btVector3 angVel);

	//Optimization for the iterative solver: avoid calculating constant terms involving inertia, normal, relative position
	public native void applyImpulse(@Const @ByRef btVector3 linearComponent, @Const @ByRef btVector3 angularComponent, @Cast("const btScalar") double impulseMagnitude);

	public native void internalApplyPushImpulse(@Const @ByRef btVector3 linearComponent, @Const @ByRef btVector3 angularComponent, @Cast("btScalar") double impulseMagnitude);

	public native @Const @ByRef btVector3 getDeltaLinearVelocity();

	public native @Const @ByRef btVector3 getDeltaAngularVelocity();

	public native @Const @ByRef btVector3 getPushVelocity();

	public native @Const @ByRef btVector3 getTurnVelocity();

	////////////////////////////////////////////////
	/**some internal methods, don't use them */

	public native @ByRef btVector3 internalGetDeltaLinearVelocity();

	public native @ByRef btVector3 internalGetDeltaAngularVelocity();

	public native @Const @ByRef btVector3 internalGetAngularFactor();

	public native @Const @ByRef btVector3 internalGetInvMass();

	public native void internalSetInvMass(@Const @ByRef btVector3 invMass);

	public native @ByRef btVector3 internalGetPushVelocity();

	public native @ByRef btVector3 internalGetTurnVelocity();

	public native void internalGetVelocityInLocalPointObsolete(@Const @ByRef btVector3 rel_pos, @ByRef btVector3 velocity);

	public native void internalGetAngularVelocity(@ByRef btVector3 angVel);

	//Optimization for the iterative solver: avoid calculating constant terms involving inertia, normal, relative position
	public native void internalApplyImpulse(@Const @ByRef btVector3 linearComponent, @Const @ByRef btVector3 angularComponent, @Cast("const btScalar") double impulseMagnitude);

	public native void writebackVelocity();

	public native void writebackVelocityAndTransform(@Cast("btScalar") double timeStep, @Cast("btScalar") double splitImpulseTurnErp);
}
