/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.caffe;

import java.util.Arrays;
import org.bytedeco.caffe.FloatBlob;
import org.bytedeco.caffe.presets.caffe;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;

@Name(value={"std::vector<caffe::Blob<float>*>"})
@Properties(inherit={caffe.class})
public class FloatBlobVector
extends Pointer {
    public FloatBlobVector(Pointer p) {
        super(p);
    }

    public FloatBlobVector(FloatBlob value) {
        this(1L);
        this.put(0L, value);
    }

    public FloatBlobVector(FloatBlob ... array) {
        this(array.length);
        this.put(array);
    }

    public FloatBlobVector() {
        this.allocate();
    }

    public FloatBlobVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native FloatBlobVector put(@ByRef FloatBlobVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    public native FloatBlob get(@Cast(value={"size_t"}) long var1);

    public native FloatBlobVector put(@Cast(value={"size_t"}) long var1, FloatBlob var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, FloatBlob var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public FloatBlob[] get() {
        FloatBlob[] array = new FloatBlob[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public FloatBlob pop_back() {
        long size = this.size();
        FloatBlob value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public FloatBlobVector push_back(FloatBlob value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public FloatBlobVector put(FloatBlob value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public FloatBlobVector put(FloatBlob ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Const
        public native FloatBlob get();
    }
}

