// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.global;

import org.bytedeco.ffmpeg.swresample.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;

public class swresample extends org.bytedeco.ffmpeg.presets.swresample {
    static { Loader.load(); }

// Parsed from <libswresample/swresample.h>

/*
 * Copyright (C) 2011-2013 Michael Niedermayer (michaelni@gmx.at)
 *
 * This file is part of libswresample
 *
 * libswresample is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * libswresample is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with libswresample; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef SWRESAMPLE_SWRESAMPLE_H
// #define SWRESAMPLE_SWRESAMPLE_H

/**
 * \file
 * \ingroup lswr
 * libswresample public header
 */

/**
 * \defgroup lswr libswresample
 * \{
 *
 * Audio resampling, sample format conversion and mixing library.
 *
 * Interaction with lswr is done through SwrContext, which is
 * allocated with swr_alloc() or swr_alloc_set_opts(). It is opaque, so all parameters
 * must be set with the \ref avoptions API.
 *
 * The first thing you will need to do in order to use lswr is to allocate
 * SwrContext. This can be done with swr_alloc() or swr_alloc_set_opts(). If you
 * are using the former, you must set options through the \ref avoptions API.
 * The latter function provides the same feature, but it allows you to set some
 * common options in the same statement.
 *
 * For example the following code will setup conversion from planar float sample
 * format to interleaved signed 16-bit integer, downsampling from 48kHz to
 * 44.1kHz and downmixing from 5.1 channels to stereo (using the default mixing
 * matrix). This is using the swr_alloc() function.
 * <pre>{@code
 * SwrContext *swr = swr_alloc();
 * av_opt_set_channel_layout(swr, "in_channel_layout",  AV_CH_LAYOUT_5POINT1, 0);
 * av_opt_set_channel_layout(swr, "out_channel_layout", AV_CH_LAYOUT_STEREO,  0);
 * av_opt_set_int(swr, "in_sample_rate",     48000,                0);
 * av_opt_set_int(swr, "out_sample_rate",    44100,                0);
 * av_opt_set_sample_fmt(swr, "in_sample_fmt",  AV_SAMPLE_FMT_FLTP, 0);
 * av_opt_set_sample_fmt(swr, "out_sample_fmt", AV_SAMPLE_FMT_S16,  0);
 * }</pre>
 *
 * The same job can be done using swr_alloc_set_opts() as well:
 * <pre>{@code
 * SwrContext *swr = swr_alloc_set_opts(NULL,  // we're allocating a new context
 *                       AV_CH_LAYOUT_STEREO,  // out_ch_layout
 *                       AV_SAMPLE_FMT_S16,    // out_sample_fmt
 *                       44100,                // out_sample_rate
 *                       AV_CH_LAYOUT_5POINT1, // in_ch_layout
 *                       AV_SAMPLE_FMT_FLTP,   // in_sample_fmt
 *                       48000,                // in_sample_rate
 *                       0,                    // log_offset
 *                       NULL);                // log_ctx
 * }</pre>
 *
 * Once all values have been set, it must be initialized with swr_init(). If
 * you need to change the conversion parameters, you can change the parameters
 * using \ref AVOptions, as described above in the first example; or by using
 * swr_alloc_set_opts(), but with the first argument the allocated context.
 * You must then call swr_init() again.
 *
 * The conversion itself is done by repeatedly calling swr_convert().
 * Note that the samples may get buffered in swr if you provide insufficient
 * output space or if sample rate conversion is done, which requires "future"
 * samples. Samples that do not require future input can be retrieved at any
 * time by using swr_convert() (in_count can be set to 0).
 * At the end of conversion the resampling buffer can be flushed by calling
 * swr_convert() with NULL in and 0 in_count.
 *
 * The samples used in the conversion process can be managed with the libavutil
 * \ref lavu_sampmanip "samples manipulation" API, including av_samples_alloc()
 * function used in the following example.
 *
 * The delay between input and output, can at any time be found by using
 * swr_get_delay().
 *
 * The following code demonstrates the conversion loop assuming the parameters
 * from above and caller-defined functions get_input() and handle_output():
 * <pre>{@code
 * uint8_t **input;
 * int in_samples;
 *
 * while (get_input(&input, &in_samples)) {
 *     uint8_t *output;
 *     int out_samples = av_rescale_rnd(swr_get_delay(swr, 48000) +
 *                                      in_samples, 44100, 48000, AV_ROUND_UP);
 *     av_samples_alloc(&output, NULL, 2, out_samples,
 *                      AV_SAMPLE_FMT_S16, 0);
 *     out_samples = swr_convert(swr, &output, out_samples,
 *                                      input, in_samples);
 *     handle_output(output, out_samples);
 *     av_freep(&output);
 * }
 * }</pre>
 *
 * When the conversion is finished, the conversion
 * context and everything associated with it must be freed with swr_free().
 * A swr_close() function is also available, but it exists mainly for
 * compatibility with libavresample, and is not required to be called.
 *
 * There will be no memory leak if the data is not completely flushed before
 * swr_free().
 */

// #include <stdint.h>
// #include "libavutil/channel_layout.h"
// #include "libavutil/frame.h"
// #include "libavutil/samplefmt.h"

// #include "libswresample/version.h"

/**
 * \name Option constants
 * These constants are used for the \ref avoptions interface for lswr.
 * \{
 *
 */

/** Force resampling even if equal sample rate */
public static final int SWR_FLAG_RESAMPLE = 1;
//TODO use int resample ?
//long term TODO can we enable this dynamically?

/** Dithering algorithms */
/** enum SwrDitherType */
public static final int
    SWR_DITHER_NONE = 0,
    SWR_DITHER_RECTANGULAR = 1,
    SWR_DITHER_TRIANGULAR = 2,
    SWR_DITHER_TRIANGULAR_HIGHPASS = 3,

    /** not part of API/ABI */
    SWR_DITHER_NS = 64,
    SWR_DITHER_NS_LIPSHITZ = 65,
    SWR_DITHER_NS_F_WEIGHTED = 66,
    SWR_DITHER_NS_MODIFIED_E_WEIGHTED = 67,
    SWR_DITHER_NS_IMPROVED_E_WEIGHTED = 68,
    SWR_DITHER_NS_SHIBATA = 69,
    SWR_DITHER_NS_LOW_SHIBATA = 70,
    SWR_DITHER_NS_HIGH_SHIBATA = 71,
    /** not part of API/ABI */
    SWR_DITHER_NB = 72;

/** Resampling Engines */
/** enum SwrEngine */
public static final int
    /** SW Resampler */
    SWR_ENGINE_SWR = 0,
    /** SoX Resampler */
    SWR_ENGINE_SOXR = 1,
    /** not part of API/ABI */
    SWR_ENGINE_NB = 2;

/** Resampling Filter Types */
/** enum SwrFilterType */
public static final int
    /** Cubic */
    SWR_FILTER_TYPE_CUBIC = 0,
    /** Blackman Nuttall windowed sinc */
    SWR_FILTER_TYPE_BLACKMAN_NUTTALL = 1,
    /** Kaiser windowed sinc */
    SWR_FILTER_TYPE_KAISER = 2;
// Targeting ../swresample/SwrContext.java



/**
 * Get the AVClass for SwrContext. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 * @return the AVClass of SwrContext
 */
@NoException public static native @Const AVClass swr_get_class();

/**
 * \name SwrContext constructor functions
 * \{
 */

/**
 * Allocate SwrContext.
 *
 * If you use this function you will need to set the parameters (manually or
 * with swr_alloc_set_opts()) before calling swr_init().
 *
 * @see swr_alloc_set_opts(), swr_init(), swr_free()
 * @return NULL on error, allocated context otherwise
 */
@NoException public static native SwrContext swr_alloc();

/**
 * Initialize context after user parameters have been set.
 * \note The context must be configured using the AVOption API.
 *
 * @see av_opt_set_int()
 * @see av_opt_set_dict()
 *
 * @param s [in,out] Swr context to initialize
 * @return AVERROR error code in case of failure.
 */
@NoException public static native int swr_init(SwrContext s);

/**
 * Check whether an swr context has been initialized or not.
 *
 * @param s [in] Swr context to check
 * @see swr_init()
 * @return positive if it has been initialized, 0 if not initialized
 */
@NoException public static native int swr_is_initialized(SwrContext s);

/**
 * Allocate SwrContext if needed and set/reset common parameters.
 *
 * This function does not require s to be allocated with swr_alloc(). On the
 * other hand, swr_alloc() can use swr_alloc_set_opts() to set the parameters
 * on the allocated context.
 *
 * @param s               existing Swr context if available, or NULL if not
 * @param out_ch_layout   output channel layout (AV_CH_LAYOUT_*)
 * @param out_sample_fmt  output sample format (AV_SAMPLE_FMT_*).
 * @param out_sample_rate output sample rate (frequency in Hz)
 * @param in_ch_layout    input channel layout (AV_CH_LAYOUT_*)
 * @param in_sample_fmt   input sample format (AV_SAMPLE_FMT_*).
 * @param in_sample_rate  input sample rate (frequency in Hz)
 * @param log_offset      logging level offset
 * @param log_ctx         parent logging context, can be NULL
 *
 * @see swr_init(), swr_free()
 * @return NULL on error, allocated context otherwise
 */
@NoException public static native SwrContext swr_alloc_set_opts(SwrContext s,
                                      @Cast("int64_t") long out_ch_layout, @Cast("AVSampleFormat") int out_sample_fmt, int out_sample_rate,
                                      @Cast("int64_t") long in_ch_layout, @Cast("AVSampleFormat") int in_sample_fmt, int in_sample_rate,
                                      int log_offset, Pointer log_ctx);

/**
 * \}
 *
 * \name SwrContext destructor functions
 * \{
 */

/**
 * Free the given SwrContext and set the pointer to NULL.
 *
 * @param s [in] a pointer to a pointer to Swr context
 */
@NoException public static native void swr_free(@Cast("SwrContext**") PointerPointer s);
@NoException public static native void swr_free(@ByPtrPtr SwrContext s);

/**
 * Closes the context so that swr_is_initialized() returns 0.
 *
 * The context can be brought back to life by running swr_init(),
 * swr_init() can also be used without swr_close().
 * This function is mainly provided for simplifying the usecase
 * where one tries to support libavresample and libswresample.
 *
 * @param s [in,out] Swr context to be closed
 */
@NoException public static native void swr_close(SwrContext s);

/**
 * \}
 *
 * \name Core conversion functions
 * \{
 */

/** Convert audio.
 *
 * in and in_count can be set to 0 to flush the last few samples out at the
 * end.
 *
 * If more input is provided than output space, then the input will be buffered.
 * You can avoid this buffering by using swr_get_out_samples() to retrieve an
 * upper bound on the required number of output samples for the given number of
 * input samples. Conversion will run directly without copying whenever possible.
 *
 * @param s         allocated Swr context, with parameters set
 * @param out       output buffers, only the first one need be set in case of packed audio
 * @param out_count amount of space available for output in samples per channel
 * @param in        input buffers, only the first one need to be set in case of packed audio
 * @param in_count  number of input samples available in one channel
 *
 * @return number of samples output per channel, negative value on error
 */
@NoException public static native int swr_convert(SwrContext s, @Cast("uint8_t**") PointerPointer out, int out_count,
                                @Cast("const uint8_t**") PointerPointer in, int in_count);
@NoException public static native int swr_convert(SwrContext s, @Cast("uint8_t**") @ByPtrPtr BytePointer out, int out_count,
                                @Cast("const uint8_t**") @ByPtrPtr BytePointer in, int in_count);
@NoException public static native int swr_convert(SwrContext s, @Cast("uint8_t**") @ByPtrPtr ByteBuffer out, int out_count,
                                @Cast("const uint8_t**") @ByPtrPtr ByteBuffer in, int in_count);
@NoException public static native int swr_convert(SwrContext s, @Cast("uint8_t**") @ByPtrPtr byte[] out, int out_count,
                                @Cast("const uint8_t**") @ByPtrPtr byte[] in, int in_count);

/**
 * Convert the next timestamp from input to output
 * timestamps are in 1/(in_sample_rate * out_sample_rate) units.
 *
 * \note There are 2 slightly differently behaving modes.
 *       \li When automatic timestamp compensation is not used, (min_compensation >= FLT_MAX)
 *              in this case timestamps will be passed through with delays compensated
 *       \li When automatic timestamp compensation is used, (min_compensation < FLT_MAX)
 *              in this case the output timestamps will match output sample numbers.
 *              See ffmpeg-resampler(1) for the two modes of compensation.
 *
 * @param s[in]     initialized Swr context
 * @param pts[in]   timestamp for the next input sample, INT64_MIN if unknown
 * @see swr_set_compensation(), swr_drop_output(), and swr_inject_silence() are
 *      function used internally for timestamp compensation.
 * @return the output timestamp for the next output sample
 */
@NoException public static native @Cast("int64_t") long swr_next_pts(SwrContext s, @Cast("int64_t") long pts);

/**
 * \}
 *
 * \name Low-level option setting functions
 * These functons provide a means to set low-level options that is not possible
 * with the AVOption API.
 * \{
 */

/**
 * Activate resampling compensation ("soft" compensation). This function is
 * internally called when needed in swr_next_pts().
 *
 * @param s [in,out]             allocated Swr context. If it is not initialized,
 *                              or SWR_FLAG_RESAMPLE is not set, swr_init() is
 *                              called with the flag set.
 * @param sample_delta [in]  delta in PTS per sample
 * @param compensation_distance [in] number of samples to compensate for
 * @return    >= 0 on success, AVERROR error codes if:
 *            \li \c s is NULL,
 *            \li \c compensation_distance is less than 0,
 *            \li \c compensation_distance is 0 but sample_delta is not,
 *            \li compensation unsupported by resampler, or
 *            \li swr_init() fails when called.
 */
@NoException public static native int swr_set_compensation(SwrContext s, int sample_delta, int compensation_distance);

/**
 * Set a customized input channel mapping.
 *
 * @param s [in,out]           allocated Swr context, not yet initialized
 * @param channel_map [in] customized input channel mapping (array of channel
 *                            indexes, -1 for a muted channel)
 * @return >= 0 on success, or AVERROR error code in case of failure.
 */
@NoException public static native int swr_set_channel_mapping(SwrContext s, @Const IntPointer channel_map);
@NoException public static native int swr_set_channel_mapping(SwrContext s, @Const IntBuffer channel_map);
@NoException public static native int swr_set_channel_mapping(SwrContext s, @Const int[] channel_map);

/**
 * Generate a channel mixing matrix.
 *
 * This function is the one used internally by libswresample for building the
 * default mixing matrix. It is made public just as a utility function for
 * building custom matrices.
 *
 * @param in_layout           input channel layout
 * @param out_layout          output channel layout
 * @param center_mix_level    mix level for the center channel
 * @param surround_mix_level  mix level for the surround channel(s)
 * @param lfe_mix_level       mix level for the low-frequency effects channel
 * @param rematrix_maxval     if 1.0, coefficients will be normalized to prevent
 *                            overflow. if INT_MAX, coefficients will not be
 *                            normalized.
 * @param matrix [out]         mixing coefficients; matrix[i + stride * o] is
 *                            the weight of input channel i in output channel o.
 * @param stride              distance between adjacent input channels in the
 *                            matrix array
 * @param matrix_encoding     matrixed stereo downmix mode (e.g. dplii)
 * @param log_ctx             parent logging context, can be NULL
 * @return                    0 on success, negative AVERROR code on failure
 */
@NoException public static native int swr_build_matrix(@Cast("uint64_t") long in_layout, @Cast("uint64_t") long out_layout,
                     double center_mix_level, double surround_mix_level,
                     double lfe_mix_level, double rematrix_maxval,
                     double rematrix_volume, DoublePointer matrix,
                     int stride, @Cast("AVMatrixEncoding") int matrix_encoding,
                     Pointer log_ctx);
@NoException public static native int swr_build_matrix(@Cast("uint64_t") long in_layout, @Cast("uint64_t") long out_layout,
                     double center_mix_level, double surround_mix_level,
                     double lfe_mix_level, double rematrix_maxval,
                     double rematrix_volume, DoubleBuffer matrix,
                     int stride, @Cast("AVMatrixEncoding") int matrix_encoding,
                     Pointer log_ctx);
@NoException public static native int swr_build_matrix(@Cast("uint64_t") long in_layout, @Cast("uint64_t") long out_layout,
                     double center_mix_level, double surround_mix_level,
                     double lfe_mix_level, double rematrix_maxval,
                     double rematrix_volume, double[] matrix,
                     int stride, @Cast("AVMatrixEncoding") int matrix_encoding,
                     Pointer log_ctx);

/**
 * Set a customized remix matrix.
 *
 * @param s       allocated Swr context, not yet initialized
 * @param matrix  remix coefficients; matrix[i + stride * o] is
 *                the weight of input channel i in output channel o
 * @param stride  offset between lines of the matrix
 * @return  >= 0 on success, or AVERROR error code in case of failure.
 */
@NoException public static native int swr_set_matrix(SwrContext s, @Const DoublePointer matrix, int stride);
@NoException public static native int swr_set_matrix(SwrContext s, @Const DoubleBuffer matrix, int stride);
@NoException public static native int swr_set_matrix(SwrContext s, @Const double[] matrix, int stride);

/**
 * \}
 *
 * \name Sample handling functions
 * \{
 */

/**
 * Drops the specified number of output samples.
 *
 * This function, along with swr_inject_silence(), is called by swr_next_pts()
 * if needed for "hard" compensation.
 *
 * @param s     allocated Swr context
 * @param count number of samples to be dropped
 *
 * @return >= 0 on success, or a negative AVERROR code on failure
 */
@NoException public static native int swr_drop_output(SwrContext s, int count);

/**
 * Injects the specified number of silence samples.
 *
 * This function, along with swr_drop_output(), is called by swr_next_pts()
 * if needed for "hard" compensation.
 *
 * @param s     allocated Swr context
 * @param count number of samples to be dropped
 *
 * @return >= 0 on success, or a negative AVERROR code on failure
 */
@NoException public static native int swr_inject_silence(SwrContext s, int count);

/**
 * Gets the delay the next input sample will experience relative to the next output sample.
 *
 * Swresample can buffer data if more input has been provided than available
 * output space, also converting between sample rates needs a delay.
 * This function returns the sum of all such delays.
 * The exact delay is not necessarily an integer value in either input or
 * output sample rate. Especially when downsampling by a large value, the
 * output sample rate may be a poor choice to represent the delay, similarly
 * for upsampling and the input sample rate.
 *
 * @param s     swr context
 * @param base  timebase in which the returned delay will be:
 *              \li if it's set to 1 the returned delay is in seconds
 *              \li if it's set to 1000 the returned delay is in milliseconds
 *              \li if it's set to the input sample rate then the returned
 *                  delay is in input samples
 *              \li if it's set to the output sample rate then the returned
 *                  delay is in output samples
 *              \li if it's the least common multiple of in_sample_rate and
 *                  out_sample_rate then an exact rounding-free delay will be
 *                  returned
 * @return     the delay in 1 / \c base units.
 */
@NoException public static native @Cast("int64_t") long swr_get_delay(SwrContext s, @Cast("int64_t") long base);

/**
 * Find an upper bound on the number of samples that the next swr_convert
 * call will output, if called with in_samples of input samples. This
 * depends on the internal state, and anything changing the internal state
 * (like further swr_convert() calls) will may change the number of samples
 * swr_get_out_samples() returns for the same number of input samples.
 *
 * @param in_samples    number of input samples.
 * \note any call to swr_inject_silence(), swr_convert(), swr_next_pts()
 *       or swr_set_compensation() invalidates this limit
 * \note it is recommended to pass the correct available buffer size
 *       to all functions like swr_convert() even if swr_get_out_samples()
 *       indicates that less would be used.
 * @return an upper bound on the number of samples that the next swr_convert
 *          will output or a negative value to indicate an error
 */
@NoException public static native int swr_get_out_samples(SwrContext s, int in_samples);

/**
 * \}
 *
 * \name Configuration accessors
 * \{
 */

/**
 * Return the \ref LIBSWRESAMPLE_VERSION_INT constant.
 *
 * This is useful to check if the build-time libswresample has the same version
 * as the run-time one.
 *
 * @return     the unsigned int-typed version
 */
@NoException public static native @Cast("unsigned") int swresample_version();

/**
 * Return the swr build-time configuration.
 *
 * @return     the build-time \c ./configure flags
 */
@NoException public static native @Cast("const char*") BytePointer swresample_configuration();

/**
 * Return the swr license.
 *
 * @return     the license of libswresample, determined at build-time
 */
@NoException public static native @Cast("const char*") BytePointer swresample_license();

/**
 * \}
 *
 * \name AVFrame based API
 * \{
 */

/**
 * Convert the samples in the input AVFrame and write them to the output AVFrame.
 *
 * Input and output AVFrames must have channel_layout, sample_rate and format set.
 *
 * If the output AVFrame does not have the data pointers allocated the nb_samples
 * field will be set using av_frame_get_buffer()
 * is called to allocate the frame.
 *
 * The output AVFrame can be NULL or have fewer allocated samples than required.
 * In this case, any remaining samples not written to the output will be added
 * to an internal FIFO buffer, to be returned at the next call to this function
 * or to swr_convert().
 *
 * If converting sample rate, there may be data remaining in the internal
 * resampling delay buffer. swr_get_delay() tells the number of
 * remaining samples. To get this data as output, call this function or
 * swr_convert() with NULL input.
 *
 * If the SwrContext configuration does not match the output and
 * input AVFrame settings the conversion does not take place and depending on
 * which AVFrame is not matching AVERROR_OUTPUT_CHANGED, AVERROR_INPUT_CHANGED
 * or the result of a bitwise-OR of them is returned.
 *
 * @see swr_delay()
 * @see swr_convert()
 * @see swr_get_delay()
 *
 * @param swr             audio resample context
 * @param output          output AVFrame
 * @param input           input AVFrame
 * @return                0 on success, AVERROR on failure or nonmatching
 *                        configuration.
 */
@NoException public static native int swr_convert_frame(SwrContext swr,
                      AVFrame output, @Const AVFrame input);

/**
 * Configure or reconfigure the SwrContext using the information
 * provided by the AVFrames.
 *
 * The original resampling context is reset even on failure.
 * The function calls swr_close() internally if the context is open.
 *
 * @see swr_close();
 *
 * @param swr             audio resample context
 * @param output          output AVFrame
 * @param input           input AVFrame
 * @return                0 on success, AVERROR on failure.
 */
@NoException public static native int swr_config_frame(SwrContext swr, @Const AVFrame out, @Const AVFrame in);

/**
 * \}
 * \}
 */

// #endif /* SWRESAMPLE_SWRESAMPLE_H */


}
