// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avcodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;

import static org.bytedeco.ffmpeg.global.avcodec.*;


/**
 * AVCodec.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avcodec.class)
public class AVCodec extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVCodec() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVCodec(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVCodec(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVCodec position(long position) {
        return (AVCodec)super.position(position);
    }

    /**
     * Name of the codec implementation.
     * The name is globally unique among encoders and among decoders (but an
     * encoder and a decoder can share the same name).
     * This is the primary way to find a codec from the user perspective.
     */
    public native @Cast("const char*") BytePointer name(); public native AVCodec name(BytePointer setter);
    /**
     * Descriptive name for the codec, meant to be more human readable than name.
     * You should use the NULL_IF_CONFIG_SMALL() macro to define it.
     */
    public native @Cast("const char*") BytePointer long_name(); public native AVCodec long_name(BytePointer setter);
    public native @Cast("AVMediaType") int type(); public native AVCodec type(int setter);
    public native @Cast("AVCodecID") int id(); public native AVCodec id(int setter);
    /**
     * Codec capabilities.
     * see AV_CODEC_CAP_*
     */
    public native int capabilities(); public native AVCodec capabilities(int setter);
    /** array of supported framerates, or NULL if any, array is terminated by {0,0} */
    public native @Const AVRational supported_framerates(); public native AVCodec supported_framerates(AVRational setter);
    /** array of supported pixel formats, or NULL if unknown, array is terminated by -1 */
    public native @Cast("const AVPixelFormat*") IntPointer pix_fmts(); public native AVCodec pix_fmts(IntPointer setter);
    /** array of supported audio samplerates, or NULL if unknown, array is terminated by 0 */
    public native @Const IntPointer supported_samplerates(); public native AVCodec supported_samplerates(IntPointer setter);
    /** array of supported sample formats, or NULL if unknown, array is terminated by -1 */
    public native @Cast("const AVSampleFormat*") IntPointer sample_fmts(); public native AVCodec sample_fmts(IntPointer setter);
    /** array of support channel layouts, or NULL if unknown. array is terminated by 0 */
    public native @Cast("const uint64_t*") LongPointer channel_layouts(); public native AVCodec channel_layouts(LongPointer setter);
    /** maximum value for lowres supported by the decoder */
    public native @Cast("uint8_t") byte max_lowres(); public native AVCodec max_lowres(byte setter);
    /** AVClass for the private context */
    public native @Const AVClass priv_class(); public native AVCodec priv_class(AVClass setter);
    /** array of recognized profiles, or NULL if unknown, array is terminated by {FF_PROFILE_UNKNOWN} */
    public native @Const AVProfile profiles(); public native AVCodec profiles(AVProfile setter);

    /**
     * Group name of the codec implementation.
     * This is a short symbolic name of the wrapper backing this codec. A
     * wrapper uses some kind of external implementation for the codec, such
     * as an external library, or a codec implementation provided by the OS or
     * the hardware.
     * If this field is NULL, this is a builtin, libavcodec native codec.
     * If non-NULL, this will be the suffix in AVCodec.name in most cases
     * (usually AVCodec.name will be of the form "<codec_name>_<wrapper_name>").
     */
    public native @Cast("const char*") BytePointer wrapper_name(); public native AVCodec wrapper_name(BytePointer setter);

    /*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavcodec and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     */
    public native int priv_data_size(); public native AVCodec priv_data_size(int setter);
    public native AVCodec next(); public native AVCodec next(AVCodec setter);
    /**
     * \name Frame-level threading support functions
     * \{
     */
    /**
     * If defined, called on thread contexts when they are created.
     * If the codec allocates writable tables in init(), re-allocate them here.
     * priv_data will be set to a copy of the original.
     */
    public static class Init_thread_copy_AVCodecContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Init_thread_copy_AVCodecContext(Pointer p) { super(p); }
        protected Init_thread_copy_AVCodecContext() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext arg0);
    }
    public native Init_thread_copy_AVCodecContext init_thread_copy(); public native AVCodec init_thread_copy(Init_thread_copy_AVCodecContext setter);
    /**
     * Copy necessary context variables from a previous thread context to the current one.
     * If not defined, the next thread will start automatically; otherwise, the codec
     * must call ff_thread_finish_setup().
     *
     * dst and src will (rarely) point to the same context, in which case memcpy should be skipped.
     */
    public static class Update_thread_context_AVCodecContext_AVCodecContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Update_thread_context_AVCodecContext_AVCodecContext(Pointer p) { super(p); }
        protected Update_thread_context_AVCodecContext_AVCodecContext() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext dst, @Const AVCodecContext src);
    }
    public native Update_thread_context_AVCodecContext_AVCodecContext update_thread_context(); public native AVCodec update_thread_context(Update_thread_context_AVCodecContext_AVCodecContext setter);
    /** \} */

    /**
     * Private codec-specific defaults.
     */
    public native @Const AVCodecDefault defaults(); public native AVCodec defaults(AVCodecDefault setter);

    /**
     * Initialize codec static data, called from avcodec_register().
     *
     * This is not intended for time consuming operations as it is
     * run for every codec regardless of that codec being used.
     */
    public static class Init_static_data_AVCodec extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Init_static_data_AVCodec(Pointer p) { super(p); }
        protected Init_static_data_AVCodec() { allocate(); }
        private native void allocate();
        public native void call(AVCodec codec);
    }
    public native Init_static_data_AVCodec init_static_data(); public native AVCodec init_static_data(Init_static_data_AVCodec setter);

    public static class Init_AVCodecContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Init_AVCodecContext(Pointer p) { super(p); }
        protected Init_AVCodecContext() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext arg0);
    }
    public native Init_AVCodecContext init(); public native AVCodec init(Init_AVCodecContext setter);
    public static class Encode_sub_AVCodecContext_BytePointer_int_AVSubtitle extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Encode_sub_AVCodecContext_BytePointer_int_AVSubtitle(Pointer p) { super(p); }
        protected Encode_sub_AVCodecContext_BytePointer_int_AVSubtitle() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext arg0, @Cast("uint8_t*") BytePointer buf, int buf_size,
                          @Const AVSubtitle sub);
    }
    public native Encode_sub_AVCodecContext_BytePointer_int_AVSubtitle encode_sub(); public native AVCodec encode_sub(Encode_sub_AVCodecContext_BytePointer_int_AVSubtitle setter);
    /**
     * Encode data to an AVPacket.
     *
     * @param      avctx          codec context
     * @param      avpkt          output AVPacket (may contain a user-provided buffer)
     * @param frame [in]          AVFrame containing the raw data to be encoded
     * @param got_packet_ptr [out] encoder sets to 0 or 1 to indicate that a
     *                            non-empty packet was returned in avpkt.
     * @return 0 on success, negative error code on failure
     */
    public static class Encode2_AVCodecContext_AVPacket_AVFrame_IntPointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Encode2_AVCodecContext_AVPacket_AVFrame_IntPointer(Pointer p) { super(p); }
        protected Encode2_AVCodecContext_AVPacket_AVFrame_IntPointer() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext avctx, AVPacket avpkt, @Const AVFrame frame,
                       IntPointer got_packet_ptr);
    }
    public native Encode2_AVCodecContext_AVPacket_AVFrame_IntPointer encode2(); public native AVCodec encode2(Encode2_AVCodecContext_AVPacket_AVFrame_IntPointer setter);
    public static class Decode_AVCodecContext_Pointer_IntPointer_AVPacket extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Decode_AVCodecContext_Pointer_IntPointer_AVPacket(Pointer p) { super(p); }
        protected Decode_AVCodecContext_Pointer_IntPointer_AVPacket() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext arg0, Pointer outdata, IntPointer outdata_size, AVPacket avpkt);
    }
    public native Decode_AVCodecContext_Pointer_IntPointer_AVPacket decode(); public native AVCodec decode(Decode_AVCodecContext_Pointer_IntPointer_AVPacket setter);
    public static class Close_AVCodecContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Close_AVCodecContext(Pointer p) { super(p); }
        protected Close_AVCodecContext() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext arg0);
    }
    public native @Name("close") Close_AVCodecContext _close(); public native AVCodec _close(Close_AVCodecContext setter);
    /**
     * Encode API with decoupled packet/frame dataflow. The API is the
     * same as the avcodec_ prefixed APIs (avcodec_send_frame() etc.), except
     * that:
     * - never called if the codec is closed or the wrong type,
     * - if AV_CODEC_CAP_DELAY is not set, drain frames are never sent,
     * - only one drain frame is ever passed down,
     */
    public static class Send_frame_AVCodecContext_AVFrame extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Send_frame_AVCodecContext_AVFrame(Pointer p) { super(p); }
        protected Send_frame_AVCodecContext_AVFrame() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext avctx, @Const AVFrame frame);
    }
    public native Send_frame_AVCodecContext_AVFrame send_frame(); public native AVCodec send_frame(Send_frame_AVCodecContext_AVFrame setter);
    public static class Receive_packet_AVCodecContext_AVPacket extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Receive_packet_AVCodecContext_AVPacket(Pointer p) { super(p); }
        protected Receive_packet_AVCodecContext_AVPacket() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext avctx, AVPacket avpkt);
    }
    public native Receive_packet_AVCodecContext_AVPacket receive_packet(); public native AVCodec receive_packet(Receive_packet_AVCodecContext_AVPacket setter);

    /**
     * Decode API with decoupled packet/frame dataflow. This function is called
     * to get one output frame. It should call ff_decode_get_packet() to obtain
     * input data.
     */
    public static class Receive_frame_AVCodecContext_AVFrame extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Receive_frame_AVCodecContext_AVFrame(Pointer p) { super(p); }
        protected Receive_frame_AVCodecContext_AVFrame() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext avctx, AVFrame frame);
    }
    public native Receive_frame_AVCodecContext_AVFrame receive_frame(); public native AVCodec receive_frame(Receive_frame_AVCodecContext_AVFrame setter);
    /**
     * Flush buffers.
     * Will be called when seeking
     */
    public static class Flush_AVCodecContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Flush_AVCodecContext(Pointer p) { super(p); }
        protected Flush_AVCodecContext() { allocate(); }
        private native void allocate();
        public native void call(AVCodecContext arg0);
    }
    public native Flush_AVCodecContext flush(); public native AVCodec flush(Flush_AVCodecContext setter);
    /**
     * Internal codec capabilities.
     * See FF_CODEC_CAP_* in internal.h
     */
    public native int caps_internal(); public native AVCodec caps_internal(int setter);

    /**
     * Decoding only, a comma-separated list of bitstream filters to apply to
     * packets before decoding.
     */
    public native @Cast("const char*") BytePointer bsfs(); public native AVCodec bsfs(BytePointer setter);

    /**
     * Array of pointers to hardware configurations supported by the codec,
     * or NULL if no hardware supported.  The array is terminated by a NULL
     * pointer.
     *
     * The user can only access this field via avcodec_get_hw_config().
     */
    public native @Cast("const AVCodecHWConfigInternal*") Pointer hw_configs(int i); public native AVCodec hw_configs(int i, Pointer setter);
    @MemberGetter public native @Cast("const AVCodecHWConfigInternal**") PointerPointer hw_configs();
}
