// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avutil;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ffmpeg.global.avutil.*;


/**
 * Descriptor that unambiguously describes how the bits of a pixel are
 * stored in the up to 4 data planes of an image. It also stores the
 * subsampling factors and number of components.
 *
 * \note This is separate of the colorspace (RGB, YCbCr, YPbPr, JPEG-style YUV
 *       and all the YUV variants) AVPixFmtDescriptor just stores how values
 *       are stored not what these values represent.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avutil.class)
public class AVPixFmtDescriptor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVPixFmtDescriptor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVPixFmtDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVPixFmtDescriptor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVPixFmtDescriptor position(long position) {
        return (AVPixFmtDescriptor)super.position(position);
    }
    @Override public AVPixFmtDescriptor getPointer(long i) {
        return new AVPixFmtDescriptor(this).position(position + i);
    }

    public native @Cast("const char*") BytePointer name(); public native AVPixFmtDescriptor name(BytePointer setter);
    /** The number of components each pixel has, (1-4) */
    public native @Cast("uint8_t") byte nb_components(); public native AVPixFmtDescriptor nb_components(byte setter);

    /**
     * Amount to shift the luma width right to find the chroma width.
     * For YV12 this is 1 for example.
     * chroma_width = AV_CEIL_RSHIFT(luma_width, log2_chroma_w)
     * The note above is needed to ensure rounding up.
     * This value only refers to the chroma components.
     */
    public native @Cast("uint8_t") byte log2_chroma_w(); public native AVPixFmtDescriptor log2_chroma_w(byte setter);

    /**
     * Amount to shift the luma height right to find the chroma height.
     * For YV12 this is 1 for example.
     * chroma_height= AV_CEIL_RSHIFT(luma_height, log2_chroma_h)
     * The note above is needed to ensure rounding up.
     * This value only refers to the chroma components.
     */
    public native @Cast("uint8_t") byte log2_chroma_h(); public native AVPixFmtDescriptor log2_chroma_h(byte setter);

    /**
     * Combination of AV_PIX_FMT_FLAG_... flags.
     */
    public native @Cast("uint64_t") long flags(); public native AVPixFmtDescriptor flags(long setter);

    /**
     * Parameters that describe how pixels are packed.
     * If the format has 1 or 2 components, then luma is 0.
     * If the format has 3 or 4 components:
     *   if the RGB flag is set then 0 is red, 1 is green and 2 is blue;
     *   otherwise 0 is luma, 1 is chroma-U and 2 is chroma-V.
     *
     * If present, the Alpha channel is always the last component.
     */
    public native @ByRef AVComponentDescriptor comp(int i); public native AVPixFmtDescriptor comp(int i, AVComponentDescriptor setter);
    @MemberGetter public native AVComponentDescriptor comp();

    /**
     * Alternative comma-separated names.
     */
    public native @Cast("const char*") BytePointer alias(); public native AVPixFmtDescriptor alias(BytePointer setter);
}
