// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avutil;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ffmpeg.global.avutil.*;


/**
 * This struct describes a set or pool of "hardware" frames (i.e. those with
 * data not located in normal system memory). All the frames in the pool are
 * assumed to be allocated in the same way and interchangeable.
 *
 * This struct is reference-counted with the AVBuffer mechanism and tied to a
 * given AVHWDeviceContext instance. The av_hwframe_ctx_alloc() constructor
 * yields a reference, whose data field points to the actual AVHWFramesContext
 * struct.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avutil.class)
public class AVHWFramesContext extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVHWFramesContext() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVHWFramesContext(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVHWFramesContext(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVHWFramesContext position(long position) {
        return (AVHWFramesContext)super.position(position);
    }
    @Override public AVHWFramesContext getPointer(long i) {
        return new AVHWFramesContext((Pointer)this).offsetAddress(i);
    }

    /**
     * A class for logging.
     */
    public native @Const AVClass av_class(); public native AVHWFramesContext av_class(AVClass setter);

    /**
     * Private data used internally by libavutil. Must not be accessed in any
     * way by the caller.
     */
    public native AVHWFramesInternal internal(); public native AVHWFramesContext internal(AVHWFramesInternal setter);

    /**
     * A reference to the parent AVHWDeviceContext. This reference is owned and
     * managed by the enclosing AVHWFramesContext, but the caller may derive
     * additional references from it.
     */
    public native AVBufferRef device_ref(); public native AVHWFramesContext device_ref(AVBufferRef setter);

    /**
     * The parent AVHWDeviceContext. This is simply a pointer to
     * device_ref->data provided for convenience.
     *
     * Set by libavutil in av_hwframe_ctx_init().
     */
    public native AVHWDeviceContext device_ctx(); public native AVHWFramesContext device_ctx(AVHWDeviceContext setter);

    /**
     * The format-specific data, allocated and freed automatically along with
     * this context.
     *
     * Should be cast by the user to the format-specific context defined in the
     * corresponding header (hwframe_*.h) and filled as described in the
     * documentation before calling av_hwframe_ctx_init().
     *
     * After any frames using this context are created, the contents of this
     * struct should not be modified by the caller.
     */
    public native Pointer hwctx(); public native AVHWFramesContext hwctx(Pointer setter);

    /**
     * This field may be set by the caller before calling av_hwframe_ctx_init().
     *
     * If non-NULL, this callback will be called when the last reference to
     * this context is unreferenced, immediately before it is freed.
     */
    public static class Free_AVHWFramesContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Free_AVHWFramesContext(Pointer p) { super(p); }
        protected Free_AVHWFramesContext() { allocate(); }
        private native void allocate();
        public native void call(AVHWFramesContext ctx);
    }
    public native @Name("free") Free_AVHWFramesContext _free(); public native AVHWFramesContext _free(Free_AVHWFramesContext setter);

    /**
     * Arbitrary user data, to be used e.g. by the free() callback.
     */
    public native Pointer user_opaque(); public native AVHWFramesContext user_opaque(Pointer setter);

    /**
     * A pool from which the frames are allocated by av_hwframe_get_buffer().
     * This field may be set by the caller before calling av_hwframe_ctx_init().
     * The buffers returned by calling av_buffer_pool_get() on this pool must
     * have the properties described in the documentation in the corresponding hw
     * type's header (hwcontext_*.h). The pool will be freed strictly before
     * this struct's free() callback is invoked.
     *
     * This field may be NULL, then libavutil will attempt to allocate a pool
     * internally. Note that certain device types enforce pools allocated at
     * fixed size (frame count), which cannot be extended dynamically. In such a
     * case, initial_pool_size must be set appropriately.
     */
    public native AVBufferPool pool(); public native AVHWFramesContext pool(AVBufferPool setter);

    /**
     * Initial size of the frame pool. If a device type does not support
     * dynamically resizing the pool, then this is also the maximum pool size.
     *
     * May be set by the caller before calling av_hwframe_ctx_init(). Must be
     * set if pool is NULL and the device type does not support dynamic pools.
     */
    public native int initial_pool_size(); public native AVHWFramesContext initial_pool_size(int setter);

    /**
     * The pixel format identifying the underlying HW surface type.
     *
     * Must be a hwaccel format, i.e. the corresponding descriptor must have the
     * AV_PIX_FMT_FLAG_HWACCEL flag set.
     *
     * Must be set by the user before calling av_hwframe_ctx_init().
     */
    public native @Cast("AVPixelFormat") int format(); public native AVHWFramesContext format(int setter);

    /**
     * The pixel format identifying the actual data layout of the hardware
     * frames.
     *
     * Must be set by the caller before calling av_hwframe_ctx_init().
     *
     * \note when the underlying API does not provide the exact data layout, but
     * only the colorspace/bit depth, this field should be set to the fully
     * planar version of that format (e.g. for 8-bit 420 YUV it should be
     * AV_PIX_FMT_YUV420P, not AV_PIX_FMT_NV12 or anything else).
     */
    public native @Cast("AVPixelFormat") int sw_format(); public native AVHWFramesContext sw_format(int setter);

    /**
     * The allocated dimensions of the frames in this pool.
     *
     * Must be set by the user before calling av_hwframe_ctx_init().
     */
    public native int width(); public native AVHWFramesContext width(int setter);
    public native int height(); public native AVHWFramesContext height(int setter);
}
