// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.flycapture.FlyCapture2;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.flycapture.global.FlyCapture2.*;


    /**
     * A specific camera property. \n
     * For example, to set the gain to 12dB, set the following values:
     * - \a type - \c GAIN
     * - \a absControl - \c true
     * - \a onePush - \c false
     * - \a onOff - \c true
     * - \a autoManualMode - \c false
     * - \a absValue - \c 12.0
     */
    @Namespace("FlyCapture2") @NoOffset @Properties(inherit = org.bytedeco.flycapture.presets.FlyCapture2.class)
public class Property extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Property(Pointer p) { super(p); }
    
        /** Property info type. */
        public native @Cast("FlyCapture2::PropertyType") int type(); public native Property type(int setter);
        /** Flag indicating if the property is present. */
        public native @Cast("bool") boolean present(); public native Property present(boolean setter);
        /**
         * Flag controlling absolute mode (real world units)
         * or non-absolute mode (camera internal units).
         */
        public native @Cast("bool") boolean absControl(); public native Property absControl(boolean setter);
        /** Flag controlling one push. */
        public native @Cast("bool") boolean onePush(); public native Property onePush(boolean setter);
        /** Flag controlling on/off. */
        public native @Cast("bool") boolean onOff(); public native Property onOff(boolean setter);
        /** Flag controlling auto. */
        public native @Cast("bool") boolean autoManualMode(); public native Property autoManualMode(boolean setter);
        /**
         * Value A (integer).
         * Used to configure properties in non-absolute mode.
         */
        public native @Cast("unsigned int") int valueA(); public native Property valueA(int setter);
        /**
         * Value B (integer). For white balance, value B applies to the blue value and
         * value A applies to the red value.
         */
        public native @Cast("unsigned int") int valueB(); public native Property valueB(int setter);
        /**
        * Floating point value.
        * Used to configure properties in absolute mode.
        */
        public native float absValue(); public native Property absValue(float setter);
        /** Reserved for future use. */
        public native @Cast("unsigned int") int reserved(int i); public native Property reserved(int i, int setter);
        @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

        public Property() { super((Pointer)null); allocate(); }
        private native void allocate();

        public Property( @Cast("FlyCapture2::PropertyType") int propType ) { super((Pointer)null); allocate(propType); }
        private native void allocate( @Cast("FlyCapture2::PropertyType") int propType );
    }
