// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.flycapture.FlyCapture2_C;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.flycapture.FlyCapture2.*;
import static org.bytedeco.flycapture.global.FlyCapture2.*;

import static org.bytedeco.flycapture.global.FlyCapture2_C.*;


    /*@}*/

    /**
     * Configuration for a camera. These options are options that are
     * generally should be set before starting isochronous transfer.
     */
    @Properties(inherit = org.bytedeco.flycapture.presets.FlyCapture2_C.class)
public class fc2Config extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public fc2Config() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public fc2Config(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public fc2Config(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public fc2Config position(long position) {
            return (fc2Config)super.position(position);
        }
    
        /** Number of buffers used by the FlyCapture2 library to grab images. */
        public native @Cast("unsigned int") int numBuffers(); public native fc2Config numBuffers(int setter);

        /**
         * Number of notifications per image. This value should only be set
         * after the image settings to be used is set to the camera.
         * The default number of notifications is 1.
         *
         * There are 4 general scenarios:
         * - 1 notification - End of image
         * - 2 notifications - After first packet and end of image
         * - 3 notifications - After first packet, middle of image, end of image
         * - x notifications - After first packet, (x -2) spread evenly, end of image
         *
         * Specifying zero for the number of notifications will be ignored (the current value
         * will not be modified).
         *
         * Note that the event numbers start at 0. Ex. when 3 notifications are
         * used, the three events will be 0, 1 and 2.
         */
        public native @Cast("unsigned int") int numImageNotifications(); public native fc2Config numImageNotifications(int setter);

        /**
         *  Minimum number of notifications needed for the current image
         *  settings on the camera. Read-only value.
         */
        public native @Cast("unsigned int") int minNumImageNotifications(); public native fc2Config minNumImageNotifications(int setter);

        /**
         * Time in milliseconds that RetrieveBuffer() and WaitForBufferEvent()
         * will wait for an image before timing out and returning.
         */
        public native int grabTimeout(); public native fc2Config grabTimeout(int setter);

        /** Grab mode for the camera. The default is DROP_FRAMES. */
        public native @Cast("fc2GrabMode") int grabMode(); public native fc2Config grabMode(int setter);

        /** This parameter enables RetrieveBuffer to run in high
         *  performance mode.  This means that any interaction
         *  with the camera, other than grabbing the image is disabled.
         *  Currently Retrieve buffer reads registers on the camera to
         *  determine which embedded image information settings have been
         *  enabled, and it reads what the bayer tile is currently set to.
         *  When High Performance mode is on, these reads are disabled.  This
         *  means that any changes to the Bayer Tile or to the Embedded image
         *  info after StartCapture() will not be tracked when made using
         *  direct register writes.  If the corresponding SetEmbededImageInfo()
         *  and GetEmbededImageInfo() calls are used then the changes will be
         *  appropriately reflected.  This also means that changes to embedded
         *  image info from other processes will not be updated either. */
        public native @Cast("BOOL") int highPerformanceRetrieveBuffer(); public native fc2Config highPerformanceRetrieveBuffer(int setter);

        /** Isochronous bus speed. */
        public native @Cast("fc2BusSpeed") int isochBusSpeed(); public native fc2Config isochBusSpeed(int setter);

        /** Asynchronous bus speed. */
        public native @Cast("fc2BusSpeed") int asyncBusSpeed(); public native fc2Config asyncBusSpeed(int setter);

        /**
         * Bandwidth allocation flag that tells the camera the bandwidth
         * allocation strategy to employ.
         */
        public native @Cast("fc2BandwidthAllocation") int bandwidthAllocation(); public native fc2Config bandwidthAllocation(int setter);

        /**
         * Number of retries to perform when a register read/write timeout
         * is received by the library. The default value is 0.
         */
        public native @Cast("unsigned int") int registerTimeoutRetries(); public native fc2Config registerTimeoutRetries(int setter);

        /**
         * Register read/write timeout value, in microseconds.
         * The default value is dependent on the interface type.
         */
        public native @Cast("unsigned int") int registerTimeout(); public native fc2Config registerTimeout(int setter);

        /** Reserved for future use */
        public native @Cast("unsigned int") int reserved(int i); public native fc2Config reserved(int i, int setter);
        @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

    }
