/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.gradle.javacpp;

import groovy.util.Node;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.gradle.javacpp.BuildPlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.FileBasedMavenArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildExtension {
    private static final Constructor<FileBasedMavenArtifact> compatibleArtifactConstructor;
    private static final boolean isLegacy;
    private final Logger logger = LoggerFactory.getLogger(BuildExtension.class);
    BuildPlugin plugin;
    Project project;

    public BuildExtension(BuildPlugin plugin) {
        this.plugin = plugin;
        this.project = plugin.project;
    }

    public List<MavenArtifact> existingArtifacts(Configuration configuration) throws IOException {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        BasePluginConvention bc = (BasePluginConvention)this.project.getConvention().getPlugin(BasePluginConvention.class);
        File libsDir = new File(this.project.getBuildDir(), bc.getLibsDirName());
        libsDir.mkdirs();
        try {
            Field nameField = DefaultProject.class.getDeclaredField("name");
            nameField.setAccessible(true);
            String name = (String)nameField.get(this.project);
            nameField.set(this.project, name + "-renamed");
            for (ResolvedDependency rd : configuration.getResolvedConfiguration().getLenientConfiguration().getFirstLevelModuleDependencies()) {
                if (!rd.getModuleGroup().equals(this.project.getGroup()) || !rd.getModuleName().equals(name)) continue;
                for (ResolvedArtifact ra : rd.getModuleArtifacts()) {
                    if (ra.getClassifier() == null || ra.getClassifier().equals(this.plugin.getPlatform() + this.plugin.getPlatformExtension())) continue;
                    try {
                        File in = ra.getFile();
                        File out = new File(libsDir, in.getName());
                        Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        FileBasedMavenArtifact ma = isLegacy ? compatibleArtifactConstructor.newInstance(out) : compatibleArtifactConstructor.newInstance(out, DefaultTaskDependencyFactory.withNoAssociatedProject());
                        ma.setClassifier(ra.getClassifier());
                        artifacts.add((MavenArtifact)ma);
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
            nameField.set(this.project, name);
        }
        catch (ReflectiveOperationException e) {
            this.logger.warn("Could not get artifacts: " + e);
        }
        return artifacts;
    }

    public Action<? extends XmlProvider> xmlAction(Configuration configuration) {
        return this.xmlAction(configuration, null);
    }

    public Action<? extends XmlProvider> xmlAction(final Configuration configuration, final String extension) {
        return new Action<XmlProvider>(){

            public void execute(XmlProvider xml) {
                int i;
                String[] allPlatforms = new String[]{"android-arm", "android-arm64", "android-x86", "android-x86_64", "ios-arm", "ios-arm64", "ios-x86", "ios-x86_64", "linux-armhf", "linux-arm64", "linux-ppc64le", "linux-x86", "linux-x86_64", "macosx-arm64", "macosx-x86_64", "windows-x86", "windows-x86_64"};
                String[] osNameFrom = new String[]{"linux", "mac os x", "windows"};
                String[] osNameKernel = new String[]{"linux", "darwin", "windows"};
                String[] osNameType = new String[]{"name", "name", "family"};
                String[] osNameTo = new String[]{"linux", "macosx", "windows"};
                String[] osArchFrom = new String[]{"arm", "aarch64", "armv8", "ppc64le", "i386", "i486", "i586", "i686", "amd64", "x86-64"};
                String[] osArchTo = new String[]{"armhf", "arm64", "arm64", "ppc64le", "x86", "x86", "x86", "x86", "x86_64", "x86_64"};
                ArrayList<String> platforms = new ArrayList<String>();
                Node propertiesNode = xml.asNode().appendNode((Object)"properties");
                Node dependenciesNode = xml.asNode().appendNode((Object)"dependencies");
                for (ResolvedDependency rd : configuration.getResolvedConfiguration().getLenientConfiguration().getFirstLevelModuleDependencies()) {
                    if (rd.getModuleGroup().equals(BuildExtension.this.project.getGroup()) && rd.getModuleName().equals(BuildExtension.this.project.getName())) {
                        Node dependencyNode = dependenciesNode.appendNode((Object)"dependency");
                        dependencyNode.appendNode((Object)"groupId", (Object)rd.getModuleGroup());
                        dependencyNode.appendNode((Object)"artifactId", (Object)rd.getModuleName());
                        dependencyNode.appendNode((Object)"version", (Object)rd.getModuleVersion());
                    }
                    for (ResolvedArtifact ra : rd.getModuleArtifacts()) {
                        Node dependencyNode = dependenciesNode.appendNode((Object)"dependency");
                        dependencyNode.appendNode((Object)"groupId", (Object)rd.getModuleGroup());
                        dependencyNode.appendNode((Object)"artifactId", (Object)rd.getModuleName());
                        dependencyNode.appendNode((Object)"version", (Object)rd.getModuleVersion());
                        if (ra.getClassifier() == null) continue;
                        String platform = ra.getClassifier();
                        if (extension != null && platform.endsWith(extension)) {
                            platform = platform.substring(0, platform.length() - extension.length());
                        }
                        dependencyNode.appendNode((Object)"classifier", (Object)("${javacpp.platform." + platform + "}"));
                        platforms.add(platform);
                    }
                }
                propertiesNode.appendNode((Object)"javacpp.platform.extension", (Object)(extension != null ? extension : ""));
                for (String platform : platforms) {
                    propertiesNode.appendNode((Object)("javacpp.platform." + platform), (Object)(platform + "${javacpp.platform.extension}"));
                }
                Node profilesNode = xml.asNode().appendNode((Object)"profiles");
                Node profileNode = profilesNode.appendNode((Object)"profile");
                profileNode.appendNode((Object)"id", (Object)"javacpp-platform-default");
                profileNode.appendNode((Object)"activation").appendNode((Object)"property").appendNode((Object)"name", (Object)"!javacpp.platform");
                propertiesNode = profileNode.appendNode((Object)"properties");
                propertiesNode.appendNode((Object)"javacpp.platform", (Object)"${os.name}-${os.arch}");
                profileNode = profilesNode.appendNode((Object)"profile");
                profileNode.appendNode((Object)"id", (Object)"javacpp-platform-custom");
                profileNode.appendNode((Object)"activation").appendNode((Object)"property").appendNode((Object)"name", (Object)"javacpp.platform");
                propertiesNode = profileNode.appendNode((Object)"properties");
                for (String profilePlatform : platforms) {
                    propertiesNode.appendNode((Object)("javacpp.platform." + profilePlatform), (Object)"${javacpp.platform}${javacpp.platform.extension}");
                }
                profileNode = profilesNode.appendNode((Object)"profile");
                profileNode.appendNode((Object)"id", (Object)"javacpp-platform-host");
                profileNode.appendNode((Object)"activation").appendNode((Object)"property").appendNode((Object)"name", (Object)"javacpp.platform.host");
                propertiesNode = profileNode.appendNode((Object)"properties");
                propertiesNode.appendNode((Object)"javacpp.platform", (Object)"${os.name}-${os.arch}${javacpp.platform.extension}");
                for (String profilePlatform : platforms) {
                    propertiesNode.appendNode((Object)("javacpp.platform." + profilePlatform), (Object)"${os.name}-${os.arch}${javacpp.platform.extension}");
                }
                profileNode = profilesNode.appendNode((Object)"profile");
                profileNode.appendNode((Object)"id", (Object)"javacpp.platform.custom-true");
                profileNode.appendNode((Object)"activation").appendNode((Object)"property").appendNode((Object)"name", (Object)"javacpp.platform.custom");
                propertiesNode = profileNode.appendNode((Object)"properties");
                propertiesNode.appendNode((Object)"javacpp.platform", (Object)"");
                for (String profilePlatform : platforms) {
                    propertiesNode.appendNode((Object)("javacpp.platform." + profilePlatform), (Object)"");
                }
                profileNode = profilesNode.appendNode((Object)"profile");
                profileNode.appendNode((Object)"id", (Object)"javacpp-platform-none");
                profileNode.appendNode((Object)"activation").appendNode((Object)"property").appendNode((Object)"name", (Object)"javacpp.platform.none");
                propertiesNode = profileNode.appendNode((Object)"properties");
                propertiesNode.appendNode((Object)"javacpp.platform", (Object)"");
                for (String profilePlatform : platforms) {
                    propertiesNode.appendNode((Object)("javacpp.platform." + profilePlatform), (Object)"");
                }
                for (String platform : platforms) {
                    profileNode = profilesNode.appendNode((Object)"profile");
                    profileNode.appendNode((Object)"id", (Object)("javacpp-platform-" + platform));
                    Node activationPropertyNode = profileNode.appendNode((Object)"activation").appendNode((Object)"property");
                    activationPropertyNode.appendNode((Object)"name", (Object)"javacpp.platform");
                    activationPropertyNode.appendNode((Object)"value", (Object)platform);
                    propertiesNode = profileNode.appendNode((Object)"properties");
                    propertiesNode.appendNode((Object)"javacpp.platform", (Object)platform);
                    for (String profilePlatform : platforms) {
                        propertiesNode.appendNode((Object)("javacpp.platform." + profilePlatform), (Object)(platform == profilePlatform ? "${javacpp.platform}${javacpp.platform.extension}" : ""));
                    }
                }
                for (String platform : platforms) {
                    profileNode = profilesNode.appendNode((Object)"profile");
                    profileNode.appendNode((Object)"id", (Object)("javacpp.platform." + platform + "-true"));
                    profileNode.appendNode((Object)"activation").appendNode((Object)"property").appendNode((Object)"name", (Object)("javacpp.platform." + platform));
                    profileNode.appendNode((Object)"properties").appendNode((Object)("javacpp.platform." + platform), (Object)(platform + "${javacpp.platform.extension}"));
                }
                for (i = 0; i < osNameFrom.length; ++i) {
                    for (int j = 0; j < osArchFrom.length; ++j) {
                        String[] stringArray;
                        if (osArchFrom[j].equals(osArchTo[j]) || j + 1 < osArchTo.length && osArchTo[j].equals(osArchTo[j + 1])) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = osArchFrom[j];
                        } else {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = osArchFrom[j];
                            stringArray = stringArray3;
                            stringArray3[1] = osArchTo[j];
                        }
                        String[] osArchs = stringArray;
                        for (String osArch : osArchs) {
                            String platform = osNameTo[i] + "-" + osArchTo[j];
                            if (!platforms.contains(platform)) continue;
                            profileNode = profilesNode.appendNode((Object)"profile");
                            profileNode.appendNode((Object)"id", (Object)("javacpp.platform.custom-" + osNameTo[i] + "-" + osArch));
                            Node activationNode = profileNode.appendNode((Object)"activation");
                            activationNode.appendNode((Object)"property").appendNode((Object)"name", (Object)"javacpp.platform.host");
                            Node osNode = activationNode.appendNode((Object)"os");
                            osNode.appendNode((Object)osNameType[i], (Object)osNameFrom[i]);
                            osNode.appendNode((Object)"arch", (Object)osArch);
                            profileNode.appendNode((Object)"properties").appendNode((Object)("javacpp.platform." + platform), (Object)(platform + "${javacpp.platform.extension}"));
                        }
                    }
                }
                for (i = 0; i < osNameFrom.length; ++i) {
                    profileNode = profilesNode.appendNode((Object)"profile");
                    profileNode.appendNode((Object)"id", (Object)osNameTo[i]);
                    profileNode.appendNode((Object)"activation").appendNode((Object)"os").appendNode((Object)osNameType[i], (Object)osNameFrom[i]);
                    propertiesNode = profileNode.appendNode((Object)"properties");
                    propertiesNode.appendNode((Object)"os.kernel", (Object)osNameKernel[i]);
                    propertiesNode.appendNode((Object)"os.name", (Object)osNameTo[i]);
                }
                for (i = 0; i < osArchFrom.length; ++i) {
                    if (osArchFrom[i].equals(osArchTo[i])) continue;
                    profileNode = profilesNode.appendNode((Object)"profile");
                    profileNode.appendNode((Object)"id", (Object)osArchFrom[i]);
                    profileNode.appendNode((Object)"activation").appendNode((Object)"os").appendNode((Object)"arch", (Object)osArchFrom[i]);
                    profileNode.appendNode((Object)"properties").appendNode((Object)"os.arch", (Object)osArchTo[i]);
                }
            }
        };
    }

    static {
        boolean legacyCheck;
        Constructor compatibleConstructor;
        try {
            compatibleConstructor = FileBasedMavenArtifact.class.getConstructor(File.class);
            legacyCheck = true;
        }
        catch (NoSuchMethodException e) {
            try {
                compatibleConstructor = FileBasedMavenArtifact.class.getConstructor(File.class, TaskDependencyFactory.class);
                legacyCheck = false;
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("Could not find constructor for FileBasedMavenArtifact (Incompatible with this gradle version)", e);
            }
        }
        isLegacy = legacyCheck;
        compatibleArtifactConstructor = compatibleConstructor;
    }
}

