/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.gradle.javacpp;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import org.bytedeco.gradle.javacpp.BuildExtension;
import org.bytedeco.gradle.javacpp.BuildTask;
import org.bytedeco.javacpp.Loader;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.WriteProperties;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class BuildPlugin
implements Plugin<Project> {
    Project project;

    String getPlatform() {
        return (String)this.project.findProperty("javacppPlatform");
    }

    String getPlatformExtension() {
        return (String)this.project.findProperty("javacppPlatformExtension");
    }

    boolean isLibraryPath(String path) {
        String p = (String)this.project.findProperty("javacpp.platform.library.path");
        return p != null && p.length() > 0 ? path.startsWith(p) : path.contains("/" + this.getPlatform() + this.getPlatformExtension() + "/");
    }

    private <T> void setProperty(String originalMethod, String propertyField, Object target, T value) {
        Method method = this.findMethod(target.getClass(), originalMethod, value.getClass());
        if (method != null) {
            try {
                this.invoke(method, target, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot set property " + method.getName() + " in " + target.getClass(), e);
            }
        } else {
            Method propertyGetter = this.findMethod(target.getClass(), propertyField);
            if (propertyGetter == null) {
                throw new RuntimeException("Cannot find property getter method " + propertyField + " in " + target.getClass());
            }
            ((Property)this.invoke(propertyGetter, target, new Object[0])).set(value);
        }
    }

    private <T> T getProperty(String originalMethod, String propertyMethod, Object target) {
        Method method = this.findMethod(target.getClass(), originalMethod);
        if (method != null) {
            return this.invoke(method, target, new Object[0]);
        }
        Method propertyGetter = this.findMethod(target.getClass(), propertyMethod);
        if (propertyGetter == null) {
            throw new RuntimeException("Cannot find property getter method " + propertyMethod + " in " + target.getClass());
        }
        return (T)((Property)this.invoke(propertyGetter, target, new Object[0])).get();
    }

    private Method findMethod(Class<?> cls, String methodName) {
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    private Method findMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            return cls.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private <T> T invoke(Method method, Object target, Object ... parameter) {
        try {
            return (T)method.invoke(target, parameter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void apply(final Project project) {
        this.project = project;
        if (!project.hasProperty("javacppPlatform")) {
            project.getExtensions().getExtraProperties().set("javacppPlatform", (Object)Loader.Detector.getPlatform());
        }
        if (!project.hasProperty("javacppPlatformExtension")) {
            project.getExtensions().getExtraProperties().set("javacppPlatformExtension", (Object)"");
        }
        if (project.getExtensions().findByName("javacppBuild") == null) {
            project.getExtensions().create("javacppBuild", BuildExtension.class, new Object[]{this});
        }
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavaPluginConvention jc = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                final SourceSet main = (SourceSet)jc.getSourceSets().getByName("main");
                Set files = main.getOutput().getClassesDirs().getFiles();
                final String[] paths = new String[files.size()];
                int n = 0;
                for (File file : files) {
                    try {
                        paths[n++] = file.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        paths[n++] = file.getAbsolutePath();
                    }
                }
                project.getTasks().register("javacppBuildCommand", BuildTask.class, (Action)new Action<BuildTask>(){

                    public void execute(BuildTask task) {
                        task.classPath = paths;
                        task.properties = BuildPlugin.this.getPlatform();
                        if (BuildPlugin.this.getPlatformExtension() != null && BuildPlugin.this.getPlatformExtension().length() > 0) {
                            task.propertyKeysAndValues = new Properties();
                            task.propertyKeysAndValues.setProperty("platform.extension", BuildPlugin.this.getPlatformExtension());
                        }
                        task.classOrPackageNames = new String[0];
                        task.workingDirectory = project.getProjectDir();
                    }
                });
                project.getTasks().register("javacppCompileJava", JavaCompile.class, (Action)new Action<JavaCompile>(){

                    public void execute(JavaCompile task) {
                        task.setSource((FileTree)main.getJava());
                        task.setClasspath(main.getCompileClasspath());
                        BuildPlugin.this.setProperty("setDestinationDir", "getDestinationDirectory", task, BuildPlugin.this.getProperty("getOutputDir", "getClassesDirectory", main.getJava()));
                        task.dependsOn(new Object[]{"javacppBuildCommand"});
                    }
                });
                project.getTasks().register("javacppBuildParser", BuildTask.class, (Action)new Action<BuildTask>(){

                    public void execute(final BuildTask task) {
                        task.classPath = paths;
                        task.properties = BuildPlugin.this.getPlatform();
                        if (BuildPlugin.this.getPlatformExtension() != null && BuildPlugin.this.getPlatformExtension().length() > 0) {
                            task.propertyKeysAndValues = new Properties();
                            task.propertyKeysAndValues.setProperty("platform.extension", BuildPlugin.this.getPlatformExtension());
                        }
                        if (task.outputDirectory == null) {
                            task.outputDirectory = (File)main.getJava().getSrcDirs().iterator().next();
                        }
                        task.dependsOn(new Object[]{"javacppCompileJava"});
                        task.doFirst((Action)new Action<Task>(){

                            public void execute(Task t) {
                                main.getJava().srcDir((Object)task.outputDirectory);
                            }
                        });
                    }
                });
                project.getTasks().getByName("compileJava").dependsOn(new Object[]{"javacppBuildParser"});
                project.getTasks().register("javacppBuildCompiler", BuildTask.class, (Action)new Action<BuildTask>(){

                    public void execute(BuildTask task) {
                        task.classPath = paths;
                        task.properties = BuildPlugin.this.getPlatform();
                        if (BuildPlugin.this.getPlatformExtension() != null && BuildPlugin.this.getPlatformExtension().length() > 0) {
                            task.propertyKeysAndValues = new Properties();
                            task.propertyKeysAndValues.setProperty("platform.extension", BuildPlugin.this.getPlatformExtension());
                        }
                        task.dependsOn(new Object[]{"compileJava"});
                    }
                });
                project.getTasks().getByName("classes").dependsOn(new Object[]{"javacppBuildCompiler"});
                project.getTasks().register("javacppPomProperties", WriteProperties.class, (Action)new Action<WriteProperties>(){

                    public void execute(WriteProperties task) {
                        Object group = project.findProperty("group");
                        Object name = project.findProperty("name");
                        Object version = project.findProperty("version");
                        task.property("groupId", group);
                        task.property("artifactId", name);
                        task.property("version", version);
                        task.setOutputFile(new File(main.getOutput().getResourcesDir(), "META-INF/maven/" + group + "/" + name + "/pom.properties"));
                    }
                });
                Jar jarTask = (Jar)project.getTasks().getByName("jar");
                jarTask.dependsOn(new Object[]{"javacppPomProperties"});
                jarTask.exclude((Spec)new Spec<FileTreeElement>(){

                    public boolean isSatisfiedBy(FileTreeElement file) {
                        return BuildPlugin.this.isLibraryPath(file.getPath());
                    }
                });
                TaskProvider javacppJarTask = project.getTasks().register("javacppJar", Jar.class, (Action)new Action<Jar>(){

                    public void execute(Jar task) {
                        task.from(new Object[]{main.getOutput()});
                        BuildPlugin.this.setProperty("setClassifier", "getArchiveClassifier", task, BuildPlugin.this.getPlatform() + BuildPlugin.this.getPlatformExtension());
                        task.include((Spec)new Spec<FileTreeElement>(){

                            public boolean isSatisfiedBy(FileTreeElement file) {
                                return file.isDirectory() || BuildPlugin.this.isLibraryPath(file.getPath());
                            }
                        });
                        task.dependsOn(new Object[]{"jar"});
                    }
                });
                project.getArtifacts().add("archives", (Object)javacppJarTask);
                TaskProvider javacppPlatformJarTask = project.getTasks().register("javacppPlatformJar", Jar.class, (Action)new Action<Jar>(){

                    public void execute(Jar task) {
                        BuildPlugin.this.setProperty("setBaseName", "getArchiveBaseName", task, project.getName() + "-platform");
                        task.dependsOn(new Object[]{"javacppJar"});
                    }
                });
                TaskProvider javacppPlatformJavadocJarTask = project.getTasks().register("javacppPlatformJavadocJar", Jar.class, (Action)new Action<Jar>(){

                    public void execute(Jar task) {
                        BuildPlugin.this.setProperty("setBaseName", "getArchiveBaseName", task, project.getName() + "-platform");
                        BuildPlugin.this.setProperty("setClassifier", "getArchiveClassifier", task, "javadoc");
                        task.dependsOn(new Object[]{"javacppPlatformJar"});
                    }
                });
                TaskProvider javacppPlatformSourcesTask = project.getTasks().register("javacppPlatformSourcesJar", Jar.class, (Action)new Action<Jar>(){

                    public void execute(Jar task) {
                        BuildPlugin.this.setProperty("setBaseName", "getArchiveBaseName", task, project.getName() + "-platform");
                        BuildPlugin.this.setProperty("setClassifier", "getArchiveClassifier", task, "sources");
                        task.dependsOn(new Object[]{"javacppPlatformJar"});
                    }
                });
                project.getConfigurations().maybeCreate("javacppPlatform");
                project.getArtifacts().add("javacppPlatform", (Object)javacppPlatformJarTask);
                project.getArtifacts().add("javacppPlatform", (Object)javacppPlatformJavadocJarTask);
                project.getArtifacts().add("javacppPlatform", (Object)javacppPlatformSourcesTask);
            }
        });
    }
}

