/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.gradle.javacpp;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.bytedeco.gradle.javacpp.BuildExecutor;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.tools.Builder;
import org.bytedeco.javacpp.tools.CommandExecutor;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.ParserException;
import org.bytedeco.javacpp.tools.Slf4jLogger;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class BuildTask
extends DefaultTask {
    String[] classPath = null;
    String[] includePath = null;
    String[] includeResource = null;
    String[] buildPath = null;
    String[] buildResource = null;
    String[] linkPath = null;
    String[] linkResource = null;
    String[] preloadPath = null;
    String[] preloadResource = null;
    String[] resourcePath = null;
    String[] executablePath = null;
    String encoding = null;
    File outputDirectory = null;
    String outputName = null;
    boolean clean = false;
    boolean generate = true;
    boolean compile = true;
    boolean deleteJniFiles = true;
    boolean header = false;
    boolean copyLibs = false;
    boolean copyResources = false;
    File configDirectory = null;
    String jarPrefix = null;
    String properties = null;
    File propertyFile = null;
    Properties propertyKeysAndValues = null;
    String[] classOrPackageNames = null;
    String[] buildCommand = null;
    String[] targetDirectory = null;
    File workingDirectory = null;
    Map<String, String> environmentVariables = null;
    String[] compilerOptions = null;
    boolean skip = false;

    public BuildTask() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task t) {
                return false;
            }
        });
    }

    @Optional
    @Classpath
    @InputFiles
    public String[] getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String[] s) {
        this.classPath = s;
    }

    @Optional
    @Input
    public String[] getIncludePath() {
        return this.includePath;
    }

    public void setIncludePath(String[] s) {
        this.includePath = s;
    }

    @Optional
    @Input
    public String[] getIncludeResource() {
        return this.includeResource;
    }

    public void setIncludeResource(String[] s) {
        this.includeResource = s;
    }

    @Optional
    @Input
    public String[] getBuildPath() {
        return this.buildPath;
    }

    public void setBuildPath(String[] s) {
        this.buildPath = s;
    }

    @Optional
    @Input
    public String[] getBuildResource() {
        return this.buildResource;
    }

    public void setBuildResource(String[] s) {
        this.buildResource = s;
    }

    @Optional
    @Input
    public String[] getLinkPath() {
        return this.linkPath;
    }

    public void setLinkPath(String[] s) {
        this.linkPath = s;
    }

    @Optional
    @Input
    public String[] getLinkResource() {
        return this.linkResource;
    }

    public void setLinkResource(String[] s) {
        this.linkResource = s;
    }

    @Optional
    @Input
    public String[] getPreloadPath() {
        return this.preloadPath;
    }

    public void setPreloadPath(String[] s) {
        this.preloadPath = s;
    }

    @Optional
    @Input
    public String[] getPreloadResource() {
        return this.preloadResource;
    }

    public void setPreloadResource(String[] s) {
        this.preloadResource = s;
    }

    @Optional
    @Input
    public String[] getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String[] s) {
        this.resourcePath = s;
    }

    @Optional
    @Input
    public String[] getExecutablePath() {
        return this.executablePath;
    }

    public void setExecutablePath(String[] s) {
        this.executablePath = s;
    }

    @Optional
    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    @Optional
    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File f) {
        this.outputDirectory = f;
    }

    @Optional
    @Input
    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String s) {
        this.outputName = s;
    }

    @Input
    public boolean getClean() {
        return this.clean;
    }

    public void setClean(boolean b) {
        this.clean = b;
    }

    @Input
    public boolean getGenerate() {
        return this.generate;
    }

    public void setGenerate(boolean b) {
        this.generate = b;
    }

    @Input
    public boolean getCompile() {
        return this.compile;
    }

    public void setCompile(boolean b) {
        this.compile = b;
    }

    @Input
    public boolean getDeleteJniFiles() {
        return this.deleteJniFiles;
    }

    public void setDeleteJniFiles(boolean b) {
        this.deleteJniFiles = b;
    }

    @Input
    public boolean getHeader() {
        return this.header;
    }

    public void setHeader(boolean b) {
        this.header = b;
    }

    @Input
    public boolean getCopyLibs() {
        return this.copyLibs;
    }

    public void setCopyLibs(boolean b) {
        this.copyLibs = b;
    }

    @Input
    public boolean getCopyResources() {
        return this.copyResources;
    }

    public void setCopyResources(boolean b) {
        this.copyResources = b;
    }

    @Optional
    @OutputDirectory
    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigDirectory(File f) {
        this.configDirectory = f;
    }

    @Optional
    @Input
    public String getJarPrefix() {
        return this.jarPrefix;
    }

    public void setJarPrefix(String s) {
        this.jarPrefix = s;
    }

    @Optional
    @Input
    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String s) {
        this.properties = s;
    }

    @Optional
    @InputFile
    public File getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(File f) {
        this.propertyFile = f;
    }

    @Optional
    @Input
    public Properties getPropertyKeysAndValues() {
        return this.propertyKeysAndValues;
    }

    public void setPropertyKeysAndValues(Properties p) {
        this.propertyKeysAndValues = p;
    }

    @Optional
    @Input
    public String[] getClassOrPackageNames() {
        return this.classOrPackageNames;
    }

    public void setClassOrPackageNames(String[] s) {
        this.classOrPackageNames = s;
    }

    @Optional
    @Input
    public String[] getBuildCommand() {
        return this.buildCommand;
    }

    public void setBuildCommand(String[] s) {
        this.buildCommand = s;
    }

    @Optional
    @Input
    public String[] getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String[] s) {
        this.targetDirectory = s;
    }

    @Optional
    @InputDirectory
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File f) {
        this.workingDirectory = f;
    }

    @Optional
    @Input
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> m) {
        this.environmentVariables = m;
    }

    @Optional
    @Input
    public String[] getCompilerOptions() {
        return this.compilerOptions;
    }

    public void setCompilerOptions(String[] s) {
        this.compilerOptions = s;
    }

    @Input
    public boolean getSkip() {
        return this.skip;
    }

    public void setSkip(boolean b) {
        this.skip = b;
    }

    @TaskAction
    public void build() throws IOException, ClassNotFoundException, NoClassDefFoundError, InterruptedException, ParserException {
        Slf4jLogger logger = new Slf4jLogger(Builder.class);
        if (this.getSkip()) {
            logger.info("Skipping execution of JavaCPP Builder");
            return;
        }
        Builder builder = new Builder((Logger)logger).classPaths(this.getClassPath()).encoding(this.getEncoding()).outputDirectory(this.getOutputDirectory()).outputName(this.getOutputName()).clean(this.getClean()).generate(this.getGenerate()).compile(this.getCompile()).deleteJniFiles(this.getDeleteJniFiles()).header(this.getHeader()).copyLibs(this.getCopyLibs()).copyResources(this.getCopyResources()).configDirectory(this.getConfigDirectory()).jarPrefix(this.getJarPrefix()).properties(this.getProperties()).propertyFile(this.getPropertyFile()).properties(this.getPropertyKeysAndValues()).classesOrPackages(this.getClassOrPackageNames()).buildCommand(this.getBuildCommand()).workingDirectory(this.getWorkingDirectory()).environmentVariables(this.getEnvironmentVariables()).compilerOptions(this.getCompilerOptions()).commandExecutor((CommandExecutor)new BuildExecutor((Logger)logger)).addProperty("platform.buildpath", this.getBuildPath()).addProperty("platform.buildresource", this.getBuildResource()).addProperty("platform.includepath", this.getIncludePath()).addProperty("platform.includeresource", this.getIncludeResource()).addProperty("platform.linkpath", this.getLinkPath()).addProperty("platform.linkresource", this.getLinkResource()).addProperty("platform.preloadpath", this.getPreloadPath()).addProperty("platform.preloadresource", this.getPreloadResource()).addProperty("platform.resourcepath", this.getResourcePath()).addProperty("platform.executablepath", this.getExecutablePath());
        String extension = builder.getProperty("platform.extension");
        this.getLogger().info("Detected platform \"" + Loader.Detector.getPlatform() + "\"");
        this.getLogger().info("Building platform \"" + builder.getProperty("platform") + "\"" + (extension != null && extension.length() > 0 ? " with extension \"" + extension + "\"" : ""));
        ExtraPropertiesExtension projectProperties = this.getProject().getExtensions().getExtraProperties();
        for (String key : builder.getProperties().stringPropertyNames()) {
            projectProperties.set("javacpp." + key, (Object)builder.getProperties().getProperty(key));
        }
        Object[] outputFiles = builder.build();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("outputFiles: " + Arrays.deepToString(outputFiles));
        }
    }
}

