/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.gradle.javacpp;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.AbstractDependencyMetadataAdapter;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.model.IvyArtifactName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlatformRule
implements ComponentMetadataRule {
    private final Logger logger = LoggerFactory.getLogger(PlatformRule.class);
    final List<String> platform;

    @Inject
    public PlatformRule(String platform) {
        this.platform = Arrays.asList(platform.split(","));
    }

    public void execute(ComponentMetadataContext context) {
        ComponentMetadataDetails component = context.getDetails();
        if (!component.getId().getName().contains("-platform")) {
            return;
        }
        component.allVariants((Action)new Action<VariantMetadata>(){

            public void execute(VariantMetadata variant) {
                variant.withDependencies((Action)new Action<DirectDependenciesMetadata>(){

                    public void execute(DirectDependenciesMetadata dependencies) {
                        Iterator i = dependencies.iterator();
                        while (i.hasNext()) {
                            DirectDependencyMetadata d = (DirectDependencyMetadata)i.next();
                            String classifier = null;
                            try {
                                List as = d.getArtifactSelectors();
                                if (as != null && as.size() > 0) {
                                    classifier = ((DependencyArtifact)as.get(0)).getClassifier();
                                }
                            }
                            catch (NoSuchMethodError ex) {
                                try {
                                    if (d instanceof AbstractDependencyMetadataAdapter) {
                                        MavenDependencyDescriptor mdd;
                                        IvyArtifactName da;
                                        ConfigurationBoundExternalDependencyMetadata m;
                                        ExternalDependencyDescriptor dd;
                                        Method getMetadata = AbstractDependencyMetadataAdapter.class.getDeclaredMethod("getOriginalMetadata", new Class[0]);
                                        getMetadata.setAccessible(true);
                                        Object o = getMetadata.invoke((Object)d, new Object[0]);
                                        if (o instanceof ConfigurationBoundExternalDependencyMetadata && (dd = (m = (ConfigurationBoundExternalDependencyMetadata)o).getDependencyDescriptor()) instanceof MavenDependencyDescriptor && (da = (mdd = (MavenDependencyDescriptor)dd).getDependencyArtifact()) != null) {
                                            classifier = da.getClassifier();
                                        }
                                    }
                                }
                                catch (ReflectiveOperationException e) {
                                    PlatformRule.this.logger.warn("Could not get the classifier of " + d + ": " + e);
                                }
                            }
                            final String c = classifier;
                            if (classifier == null || PlatformRule.this.platform.stream().filter(new Predicate<String>(){

                                @Override
                                public boolean test(String p) {
                                    return c.startsWith(p);
                                }
                            }).count() != 0L) continue;
                            i.remove();
                        }
                    }
                });
            }
        });
    }
}

